/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.events.ProgressEvent;
import org.seamcat.presentation.layout.VerticalSubPanelLayoutManager;

public class ProgressDialog
extends JDialog {
    private static final int MIN_WIDTH = 300;
    private JLabel explanationLabel;
    private JLabel progressMessageLabel;

    public ProgressDialog(Frame owner) {
        this(owner, (Object)null);
    }

    public ProgressDialog(Frame owner, Object cancelCommand) {
        super(owner);
        this.setUndecorated(true);
        this.setModal(true);
        this.getContentPane().add(this.initializeMainPanel(cancelCommand));
        this.autoSetSize();
        this.setLocationRelativeTo(owner);
        this.setResizable(false);
        EventBusFactory.getEventBus().subscribe(this);
    }

    private void autoSetSize() {
        this.pack();
        this.setSize(Math.max(this.getWidth(), 300), this.getHeight());
    }

    public void showModally() {
        this.setVisible(true);
    }

    private JPanel initializeMainPanel(final Object cancelCommand) {
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(new EmptyBorder(10, 10, 5, 10));
        mainPanel.setLayout(new VerticalSubPanelLayoutManager(10));
        this.explanationLabel = new JLabel();
        mainPanel.add(this.explanationLabel);
        this.progressMessageLabel = new JLabel("Foo");
        mainPanel.add(this.progressMessageLabel);
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        mainPanel.add(progressBar);
        if (cancelCommand != null) {
            JButton cancel = new JButton("Cancel");
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EventBusFactory.getEventBus().publish(cancelCommand);
                }
            });
            mainPanel.add(cancel);
        }
        return mainPanel;
    }

    public String getExplanation() {
        return this.explanationLabel.getText();
    }

    public void setExplanation(String explanation) {
        this.explanationLabel.setText(explanation);
        this.autoSetSize();
    }

    public void setProgressMessage(String message) {
        this.progressMessageLabel.setText(message);
    }

    public void close() {
        this.setVisible(false);
    }

    @UIEventHandler
    public void handleProgressEvent(ProgressEvent e) {
        this.setProgressMessage(e.getMessage());
    }
}

