/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.util.ArrayList;
import java.util.List;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.xy.XYSeriesCollection;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.presentation.Argument;
import org.seamcat.presentation.ExtendableXYSeries;

public class ScenarioOutlineModel
extends XYSeriesCollection {
    private XYSeriesCollection dataset = new XYSeriesCollection();
    private List<ExtendableXYSeries> series = new ArrayList<ExtendableXYSeries>();
    private double lower = Double.MAX_VALUE;
    private double upper = Double.MIN_VALUE;

    private void init(int interferenceLinks) {
        String it = "ILT";
        String ir = "ILR";
        String ilt = "Link 1" + it;
        ExtendableXYSeries e = new ExtendableXYSeries((Comparable)((Object)ilt));
        e.setType(ilt);
        this.series.add(e);
        ExtendableXYSeries vr = new ExtendableXYSeries((Comparable)((Object)"VLR"));
        vr.setType("VLR");
        this.series.add(vr);
        ExtendableXYSeries vt = new ExtendableXYSeries((Comparable)((Object)"VLT"));
        vt.setType("VLT");
        this.series.add(vt);
        for (int i = 0; i < interferenceLinks; ++i) {
            String titleT = "Link " + (i + 1) + it;
            String titleR = "Link " + (i + 1) + ir;
            if (i != 0) {
                e = new ExtendableXYSeries((Comparable)((Object)titleT));
                e.setType(titleT);
                this.series.add(e);
            }
            ExtendableXYSeries e1 = new ExtendableXYSeries((Comparable)((Object)titleR));
            e1.setType(titleR);
            this.series.add(e1);
        }
    }

    public ScenarioOutlineModel(int interferenceLinks) {
        this.init(interferenceLinks);
        this.setDataSeries();
    }

    private void setDataSeries() {
        for (ExtendableXYSeries xySeries : this.series) {
            this.addSeries(xySeries);
        }
    }

    private void setUpperAndLower(Point2D point) {
        if (point.getX() < this.lower) {
            this.lower = point.getX();
        }
        if (point.getX() > this.upper) {
            this.upper = point.getX();
        }
        if (point.getY() < this.lower) {
            this.lower = point.getY();
        }
        if (point.getY() > this.upper) {
            this.upper = point.getY();
        }
    }

    public void clearAllElements() {
        for (ExtendableXYSeries serie : this.series) {
            serie.clear();
            this.dataset.seriesChanged(new SeriesChangeEvent(serie));
        }
    }

    public void addToVictimReceiverSeries(Point2D point, Argument ... args) {
        this.series.get(1).add(point.getX(), point.getY(), args);
        this.setUpperAndLower(point);
    }

    public void addToVictimTransmitterSeries(Point2D point, Argument ... args) {
        this.series.get(2).add(point.getX(), point.getY(), args);
        this.setUpperAndLower(point);
    }

    public void addToInterferingTransmitterSeries(int index, Point2D point, Argument ... args) {
        int seriesIdx = 2 + 2 * index;
        if (index == 0) {
            seriesIdx = 0;
        }
        this.series.get(seriesIdx).add(point.getX(), point.getY(), args);
        this.setUpperAndLower(point);
    }

    public void addToInterferingReceiverSeries(int index, Point2D point, Argument ... args) {
        this.series.get(2 + (2 * index + 1)).add(point.getX(), point.getY(), args);
        this.setUpperAndLower(point);
    }
}

