/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class SeamcatDoubleCellEditor
extends DefaultCellEditor {
    private DecimalFormat format;
    JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
    private Double minimum;
    private Double maximum;

    public SeamcatDoubleCellEditor() {
        this(Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public SeamcatDoubleCellEditor(double min, double max) {
        super(new JFormattedTextField());
        this.minimum = min;
        this.maximum = max;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.getDefault());
        dfs.setDecimalSeparator(',');
        this.format = new DecimalFormat();
        this.format.setDecimalFormatSymbols(dfs);
        this.format.setMinimumFractionDigits(1);
        this.format.setMaximumFractionDigits(15);
        NumberFormatter dobFormatter = new NumberFormatter(this.format);
        dobFormatter.setMinimum(this.minimum);
        dobFormatter.setMaximum(this.maximum);
        this.ftf.setFormatterFactory(new DefaultFormatterFactory(dobFormatter));
        this.ftf.setValue(this.minimum);
        this.ftf.setHorizontalAlignment(11);
        this.ftf.setFocusLostBehavior(3);
        this.ftf.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        this.ftf.getActionMap().put("check", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SeamcatDoubleCellEditor.this.ftf.isEditValid()) {
                    if (SeamcatDoubleCellEditor.this.userSaysRevert()) {
                        SeamcatDoubleCellEditor.this.ftf.postActionEvent();
                    }
                } else {
                    try {
                        SeamcatDoubleCellEditor.this.ftf.commitEdit();
                        SeamcatDoubleCellEditor.this.ftf.postActionEvent();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        Object o = ftf.getValue();
        if (o instanceof Number) {
            return o;
        }
        try {
            return this.format.parse(o.toString());
        }
        catch (Exception exc) {
            return null;
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JFormattedTextField ftf = (JFormattedTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        ftf.setValue(value);
        return ftf;
    }

    @Override
    public boolean stopCellEditing() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        if (ftf.isEditValid()) {
            try {
                ftf.commitEdit();
            }
            catch (ParseException parseException) {}
        } else if (!this.userSaysRevert()) {
            return false;
        }
        return super.stopCellEditing();
    }

    protected boolean userSaysRevert() {
        Toolkit.getDefaultToolkit().beep();
        this.ftf.selectAll();
        Object[] options = new Object[]{"Edit", "Revert"};
        int answer = JOptionPane.showOptionDialog(SwingUtilities.getWindowAncestor(this.ftf), "The value must be a number between " + this.minimum + " and " + this.maximum + ".\nYou can either continue editing or revert to the last valid value.", "Invalid Text Entered", 0, 0, null, options, options[1]);
        if (answer == 1) {
            this.ftf.setValue(this.ftf.getValue());
            return true;
        }
        return false;
    }
}

