/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.events.SelectionMadeEvent;

public class SelectionPanel
extends JPanel {
    private List<JRadioButton> selections = new ArrayList<JRadioButton>();
    private JRadioButton selection;

    public SelectionPanel(final Object context, String ... options) {
        this.setLayout(new BoxLayout(this, 1));
        this.selections = new ArrayList<JRadioButton>();
        ButtonGroup buttonGroupType = new ButtonGroup();
        for (String option : options) {
            final JRadioButton button = new JRadioButton(option);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EventBusFactory.getEventBus().publish(new SelectionMadeEvent(context, button.getText()));
                    SelectionPanel.this.selection = button;
                }
            });
            this.selections.add(button);
            buttonGroupType.add(button);
            this.add(button);
        }
        this.selection = this.selections.get(0);
        this.setBorder(new TitledBorder("Type"));
    }

    public String getSelection() {
        return this.selection.getText();
    }

    public void setSelection(String selection) {
        for (JRadioButton button : this.selections) {
            if (!button.getText().equals(selection)) continue;
            button.setSelected(true);
            button.requestFocus();
            this.selection = button;
            return;
        }
    }
}

