/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.seamcat.Seamcat;
import org.seamcat.commands.DisplayTestCalculatorCommand;
import org.seamcat.commands.DisplayWelcomeCommand;
import org.seamcat.commands.NewBatchCommand;
import org.seamcat.commands.NewWorkspaceCommand;
import org.seamcat.commands.OpenWorkspaceCommand;
import org.seamcat.commands.OpenWorkspaceFileCommand;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.events.RecentlyUsedChangedEvent;
import org.seamcat.model.factory.Model;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.HtmlPanel;
import org.seamcat.presentation.resources.ImageLoader;

public class Welcome
extends EscapeDialog {
    private JCheckBox show;
    private JEditorPane recentlyUsed;
    private JLabel showWelcomeText;
    private ActionListener showAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Preferences pref = Preferences.userNodeForPackage(Seamcat.class);
            pref.put("SEAMCAT_WELCOME", Boolean.toString(Welcome.this.show.isSelected()));
            Model.getInstance().setShowWelcome(Welcome.this.show.isSelected());
        }
    };
    private HyperlinkListener hyperlinkListener = new HyperlinkListener(){

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType().equals(HyperlinkEvent.EventType.ENTERED)) {
                if (e.getDescription().equals("#New")) {
                    Welcome.this.setWelcomeText("Creates a new workspace based on default values");
                } else if (e.getDescription().equals("#Open")) {
                    Welcome.this.setWelcomeText("Opens an existing workspace on your local machine");
                } else if (e.getDescription().equals("#Batch")) {
                    Welcome.this.setWelcomeText("Allows to process several workspace at ones ");
                } else if (e.getDescription().equals("#Help")) {
                    Welcome.this.setWelcomeText("Redirect you to the on-line manual (internet connection required) ");
                } else if (e.getDescription().equals("#Calc")) {
                    Welcome.this.setWelcomeText("Opens the SEAMCAT pocket calculator");
                }
            } else if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                if (e.getDescription().equals("#New")) {
                    Welcome.this.setVisible(false);
                    EventBusFactory.getEventBus().publish(new NewWorkspaceCommand());
                } else if (e.getDescription().equals("#Open")) {
                    Welcome.this.setVisible(false);
                    EventBusFactory.getEventBus().publish(new OpenWorkspaceCommand());
                } else if (e.getDescription().equals("#New Batch")) {
                    Welcome.this.setVisible(false);
                    EventBusFactory.getEventBus().publish(new NewBatchCommand());
                } else if (e.getDescription().equals("#Calc")) {
                    Welcome.this.setVisible(false);
                    EventBusFactory.getEventBus().publish(new DisplayTestCalculatorCommand());
                }
            } else if (e.getEventType().equals(HyperlinkEvent.EventType.EXITED)) {
                Welcome.this.setWelcomeText("Click on icon to begin ...");
            }
        }
    };
    private HyperlinkListener recentlyUsedListener = new HyperlinkListener(){

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType().equals(HyperlinkEvent.EventType.ENTERED)) {
                String filename = e.getDescription().substring(1);
                String shortDirectoryName = filename.substring(0, 3);
                String shortFileName = "";
                if (filename.length() > 38) {
                    shortFileName = "..." + filename.substring(filename.length() - 37);
                    filename = shortDirectoryName + shortFileName;
                }
                Welcome.this.setWelcomeText("Opens " + filename);
            } else if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                Welcome.this.setVisible(false);
                String filename = e.getDescription().substring(1);
                EventBusFactory.getEventBus().publish(new OpenWorkspaceFileCommand(new File(filename)));
            } else if (e.getEventType().equals(HyperlinkEvent.EventType.EXITED)) {
                Welcome.this.setWelcomeText("Click on icon to begin ...");
            }
        }
    };

    public Welcome(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        JScrollPane scroll = new JScrollPane();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.WHITE);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.show = new JCheckBox("Show this welcome screen at startup");
        this.show.setSelected(true);
        this.show.addActionListener(this.showAction);
        this.show.setBackground(Color.WHITE);
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.setBackground(Color.WHITE);
        bottom.add((Component)this.show, "West");
        bottom.add((Component)new HtmlPanel(HtmlPanel.link("http://www.cept.org/eco", "<b>www.cept.org/eco</b>"), null, "white"), "East");
        JPanel middle = new JPanel(new BorderLayout());
        this.showWelcomeText = new JLabel("");
        middle.setBackground(Color.WHITE);
        middle.add((Component)this.showWelcomeText, "West");
        JPanel buttons = new JPanel(new GridLayout(2, 3));
        buttons.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        buttons.setBackground(Color.WHITE);
        this.recentlyUsed = new HtmlPanel("", "5px 0px 0px 5px", "white");
        this.recentlyUsed.addHyperlinkListener(this.recentlyUsedListener);
        buttons.add(this.linkable("New", ImageLoader.class.getResource("new_workspace_32x32.gif").toString()));
        buttons.add(this.recentlyUsed);
        buttons.add(this.linkable("Open", ImageLoader.class.getResource("folder_open_32x32.png").toString()));
        buttons.add(this.linkable("New Batch", ImageLoader.class.getResource("batch_add_32x32.png").toString()));
        buttons.add(this.linkable("Calc", ImageLoader.class.getResource("calculator_32x32.png").toString()));
        panel.add((Component)middle, "North");
        panel.add((Component)buttons, "Center");
        panel.add((Component)bottom, "South");
        scroll.setViewportView(panel);
        this.add(scroll);
        this.setLocation(30, 130);
        this.setSize(new Dimension(460, 320));
        EventBusFactory.getEventBus().subscribe(this);
    }

    @UIEventHandler
    public void handleDisplayWelcome(DisplayWelcomeCommand event) {
        this.setVisible(true);
    }

    @UIEventHandler
    public void handleRecentlyUsedChanged(RecentlyUsedChangedEvent event) {
        StringBuilder sb = new StringBuilder("<center><font size=3>");
        if (event.getHistory().size() != 0) {
            Iterator<String> iterator = event.getHistory().iterator();
            while (iterator.hasNext()) {
                String item;
                String name = item = iterator.next();
                if (item.length() > 18) {
                    name = "..." + item.substring(item.length() - 17);
                }
                sb.append(HtmlPanel.link("#" + item, name)).append("<br>");
            }
            if (event.getHistory().size() == 1) {
                sb.append("<br><br>");
            }
            if (event.getHistory().size() == 2) {
                sb.append("<br>");
            }
        } else {
            sb.append("no file <br>in history<br><br>");
        }
        sb.append("</font>").append("<b>Recently Used</b></center>");
        this.recentlyUsed.setText(sb.toString());
    }

    private JEditorPane linkable(String name, String image) {
        StringBuilder sb = new StringBuilder("");
        sb.append("<center><a href='#").append(name).append("'><img src=\"");
        sb.append(image).append("\"></a><br><b>").append(name);
        sb.append("</b></center>");
        HtmlPanel pane = new HtmlPanel(sb.toString(), "7px 0px 0px 15px", "white");
        pane.setLinkColor("white");
        pane.addHyperlinkListener(this.hyperlinkListener);
        return pane;
    }

    public void setWelcomeText(String text) {
        this.showWelcomeText.setText(text);
    }

    @Override
    public void setVisible(boolean visible) {
        this.setWelcomeText("Click on icon to begin ...");
        super.setVisible(visible);
    }
}

