/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JTabbedPane;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.eventbus.Subscriber;
import org.seamcat.events.InfoMessageEvent;
import org.seamcat.events.WorkspaceViewClosedEvent;
import org.seamcat.model.Workspace;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.workspace.SimulationControl;
import org.seamcat.objectutils.WorkspaceCloneHelper;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.Utils;
import org.seamcat.presentation.eventprocessing.EventProcessingPanel;
import org.seamcat.presentation.systems.ScenarioPanel;
import org.seamcat.presentation.systems.SystemsPanel;

public class WorkspaceView
extends JTabbedPane {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private SystemsPanel systems;
    private ScenarioPanel scenario;
    private EventProcessingPanel eventProcessingPanel;
    private Workspace originalWorkspace;
    private Workspace workspace;
    private boolean dirty;

    public String getWorkspaceName() {
        return this.workspace.getName();
    }

    public WorkspaceView duplicate() {
        this.updateModel();
        Workspace duplicate = WorkspaceCloneHelper.clone(this.workspace);
        duplicate.setName(duplicate.getName() + " - duplicate");
        return new WorkspaceView(duplicate);
    }

    public WorkspaceView(Workspace workspace) {
        super(1);
        this.workspace = workspace;
        this.systems = new SystemsPanel(this, workspace);
        this.scenario = new ScenarioPanel(this.systems, workspace, this);
        this.scenario.register();
        this.add(STRINGLIST.getString("TAB_SYSTEMS"), this.systems);
        this.add(STRINGLIST.getString("TAB_SCENARIO"), this.scenario);
        this.eventProcessingPanel = new EventProcessingPanel(this);
        this.add("Event Processing", this.eventProcessingPanel);
        this.setSelectedIndex(0);
        Subscriber.subscribe(this);
        this.originalWorkspace = WorkspaceCloneHelper.clone(workspace);
    }

    public void updatePanels() {
        this.scenario.refreshFromModel();
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    private void destroy() {
        Subscriber.unSubscribeDeep(this);
        this.systems = null;
        this.removeAll();
        EventBusFactory.getEventBus().publish(new WorkspaceViewClosedEvent(this));
        this.workspace = null;
    }

    public void updateModel() {
        this.scenario.updateModel();
        this.systems.updateModel();
        this.eventProcessingPanel.updateCurrentEditor();
    }

    private boolean check() {
        return MainWindow.displayScenarioCheckResults(this.workspace.getScenario().getConsistencyErrors(), false, true, MainWindow.getInstance());
    }

    public void consistencyCheck() {
        this.updateModel();
        this.workspace.createScenario();
        MainWindow.displayScenarioCheckResults(this.workspace.getScenario().getConsistencyErrors(), true, false, MainWindow.getInstance());
    }

    public boolean okToSimulate() {
        this.updateModel();
        this.workspace.createScenario();
        if (this.workspace.hasDMASubSystem() && this.workspace.getSimulationControl().numberOfEvents() > 1000) {
            switch (DialogHelper.simulationSettings()) {
                case 0: {
                    return this.prepareUIForSimulationNoCheck(false);
                }
                case 1: {
                    SimulationControl prototype = Factory.prototype(SimulationControl.class, this.workspace.getSimulationControl());
                    Factory.when(prototype.numberOfEvents()).thenReturn(100);
                    this.workspace.setSimulationControl(Factory.build(prototype));
                    this.workspace.createScenario();
                    return this.prepareUIForSimulationNoCheck(false);
                }
            }
            return false;
        }
        return this.prepareUIForSimulationNoCheck(false);
    }

    public boolean prepareUIForSimulationNoCheck(boolean batch) {
        if (batch) {
            this.updateModel();
        }
        return this.check();
    }

    public boolean match(Workspace workspace) {
        return this.workspace == workspace;
    }

    public boolean dirty() {
        this.updateModel();
        return !WorkspaceCloneHelper.equals(this.workspace, this.originalWorkspace);
    }

    public void forceSave() {
        this.updateModel();
        this.saveWorkspace();
    }

    public boolean save() {
        this.dirty = this.dirty();
        if (this.dirty) {
            this.saveWorkspace();
            return true;
        }
        return true;
    }

    public boolean close() {
        this.dirty = this.dirty();
        boolean result = !this.dirty ? true : this.closeNoResults();
        if (result) {
            this.destroy();
        }
        return result;
    }

    private boolean closeNoResults() {
        int shouldBeSaved = DialogHelper.closeNoResults(this.workspace.getName());
        switch (shouldBeSaved) {
            case 0: {
                this.saveWorkspace();
                return true;
            }
            case 1: {
                EventBusFactory.getEventBus().publish(new InfoMessageEvent(STRINGLIST.getString("CLOSE_WORKSPACE_NOT_SAVED")));
                return true;
            }
        }
        EventBusFactory.getEventBus().publish(new InfoMessageEvent(STRINGLIST.getString("CANCEL_CLOSE_OPERATION")));
        return false;
    }

    public void saveWorkspaceAs(File file) {
        this.updateModel();
        this.workspace.setPath(file);
        this.workspace.setName(Utils.filenameWithoutExtension(file));
        this.saveWorkspace();
    }

    private void saveWorkspace() {
        this.originalWorkspace = WorkspaceCloneHelper.clone(this.workspace);
        MainWindow.getInstance().saveWorkspace(this.workspace);
    }

    @Override
    public String toString() {
        return this.workspace.getName();
    }
}

