/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.batch;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.seamcat.batch.BatchJobList;
import org.seamcat.model.Workspace;
import org.seamcat.model.factory.Model;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.batch.BatchIOHandler;
import org.seamcat.presentation.batch.BatchStatusPanel;
import org.seamcat.presentation.compare.WorkspaceVectors;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.simulationview.SimulationView;

public class BatchSimulationView
extends JTabbedPane {
    private List<SimulationView> views = new ArrayList<SimulationView>();
    private BatchStatusPanel statusPanel;
    private BatchJobList jobList;
    private boolean incrementalSave = false;

    public List<WorkspaceVectors> getResultVectors() {
        ArrayList<WorkspaceVectors> vectors = new ArrayList<WorkspaceVectors>();
        for (Workspace workspace : this.jobList.getBatchJobs()) {
            vectors.add(new WorkspaceVectors(workspace.getName(), workspace.getSimulationResults()));
        }
        return vectors;
    }

    public void setTitle(String name) {
        this.jobList.setName(name);
    }

    public String getTitle() {
        return this.jobList.getName();
    }

    public BatchJobList getJobList() {
        return this.jobList;
    }

    public BatchSimulationView(BatchJobList jobList) {
        this.jobList = jobList;
        for (Workspace ws : jobList.getBatchJobs()) {
            SimulationView view = ws.isHasBeenCalculated() ? new SimulationView(ws) : new SimulationView(ws, true);
            this.views.add(view);
        }
        this.statusPanel = new BatchStatusPanel(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new BorderPanel(this.statusPanel, "Batch status"), "North");
        this.add((Component)jPanel, "Results");
        for (SimulationView view : this.views) {
            this.add((Component)view, "Results[" + view.getWorkspace().getName() + "]");
        }
    }

    public void setIncrementalSave(boolean incrementalSave) {
        this.incrementalSave = incrementalSave;
    }

    public boolean dirty() {
        for (SimulationView view : this.views) {
            if (!view.dirty()) continue;
            return true;
        }
        return false;
    }

    public boolean close() {
        if (this.dirty()) {
            int result = DialogHelper.closeDirtyBatch(this.getJobList().getName());
            if (result == 2) {
                return false;
            }
            if (result == 1) {
                return true;
            }
            this.save();
            return true;
        }
        return true;
    }

    public void startSimulation() {
        int steps = this.views.size() + 1;
        if (this.incrementalSave) {
            steps += this.views.size();
        }
        this.statusPanel.initialize(steps);
        for (SimulationView view : this.views) {
            this.statusPanel.updateStatus("Simulating: " + view.getWorkspace().getName());
            view.simulate();
            if (!this.incrementalSave) continue;
            this.statusPanel.updateStatus("Saving: " + view.getWorkspace().getName());
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Model.saveWorkspace(view.getWorkspace());
        }
        this.complete();
    }

    public void complete() {
        this.statusPanel.complete();
    }

    public void save() {
        if (!this.jobList.hasLocation()) {
            this.jobList.setAbsoluteLocation(Model.getWorkspacePath() + this.jobList.getName() + ".sbr");
        }
        BatchIOHandler.save(this.jobList);
    }
}

