/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.batch;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.seamcat.presentation.batch.BatchSimulationView;
import org.seamcat.presentation.menu.ToolBar;
import org.seamcat.presentation.report.ReportDialog;

public class BatchStatusPanel
extends JPanel {
    private JLabel status = new JLabel();
    private JProgressBar batchStatus = new JProgressBar(0, 10);

    public BatchStatusPanel(final BatchSimulationView view) {
        super(new BorderLayout());
        JButton reportWorkspace = ToolBar.button("SEAMCAT_ICON_GENERATE_REPORT", "MENU_ITEM_TEXT_REPORT");
        reportWorkspace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportDialog dialog = new ReportDialog();
                dialog.setReportSource(view.getJobList());
                dialog.setVisible(true);
            }
        });
        JPanel control = new JPanel(new BorderLayout());
        control.add((Component)new JLabel("Generate report"), "North");
        control.add((Component)reportWorkspace, "Center");
        control.add(Box.createHorizontalStrut(100), "East");
        this.add((Component)control, "West");
        JPanel progress = new JPanel(new BorderLayout());
        progress.add((Component)this.status, "North");
        progress.add((Component)this.batchStatus, "South");
        this.add((Component)progress, "Center");
    }

    public void initialize(final int steps) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BatchStatusPanel.this.batchStatus.setMaximum(steps);
                BatchStatusPanel.this.batchStatus.setValue(0);
            }
        });
    }

    public void updateStatus(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BatchStatusPanel.this.status.setText(text);
                BatchStatusPanel.this.batchStatus.setValue(BatchStatusPanel.this.batchStatus.getValue() + 1);
            }
        });
    }

    public void complete() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BatchStatusPanel.this.status.setText("Batch simulation completed");
                BatchStatusPanel.this.batchStatus.setValue(BatchStatusPanel.this.batchStatus.getMaximum());
            }
        });
    }
}

