/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.batch;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.seamcat.commands.DisplayHelpNameCommand;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.WorkspaceView;
import org.seamcat.presentation.batch.BatchView;
import org.seamcat.presentation.menu.ToolBar;
import org.seamcat.presentation.report.ReportDialog;

public class BatchToolBar
extends JPanel {
    private final JCheckBox jCheckBox;
    private JButton export;
    private JButton newWs;
    private JButton open;
    private JButton duplicate;

    public BatchToolBar(final BatchView view) {
        this.setLayout(new BorderLayout());
        JPanel bar = this.createWorkspaceToolbar();
        JButton run = ToolBar.button("SEAMCAT_ICON_SIMULATION_START", "MENU_ITEM_TEXT_RUN_EGE");
        run.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (view.okToSimulate()) {
                    MainWindow.getInstance().runBatch(view);
                }
            }
        });
        bar.add(run);
        JButton reportWorkspace = ToolBar.button("SEAMCAT_ICON_GENERATE_REPORT", "MENU_ITEM_TEXT_REPORT");
        reportWorkspace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportDialog dialog = new ReportDialog();
                dialog.setReportSource(view.getList());
                dialog.setVisible(true);
            }
        });
        bar.add(reportWorkspace);
        JButton checkConsistency = ToolBar.button("SEAMCAT_ICON_CHECK_CONSISTENCY", "MENU_ITEM_TEXT_CHECK_CONSISTENCY");
        checkConsistency.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                view.consistencyCheck();
            }
        });
        bar.add(checkConsistency);
        bar.add(ToolBar.button("SEAMCAT_ICON_HELP", "HELP_CONTENTS_MENU_ITEM_TEXT", new DisplayHelpNameCommand("http://confluence.seamcat.org/display/SH/2.6+Batch+operation")));
        this.add((Component)bar, "North");
        this.defaultToolBar();
        this.newWs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                view.handleNewWorkspace();
            }
        });
        this.open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                view.handleOpenWorkspace();
            }
        });
        this.export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                view.handleExportWorkspace();
            }
        });
        this.duplicate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                view.handleDuplicateWorkspace();
            }
        });
        this.jCheckBox = new JCheckBox("Automatically save data when a workspace completes simulation");
        this.jCheckBox.setSelected(view.isIncrementalSave());
        this.jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                view.setIncrementalSave(BatchToolBar.this.jCheckBox.isSelected());
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.jCheckBox);
        this.add((Component)jPanel, "South");
    }

    private JPanel createWorkspaceToolbar() {
        JPanel bar = new JPanel(new FlowLayout(0));
        this.newWs = ToolBar.button("SEAMCAT_ICON_WORKSPACE_NEW", "MENU_ITEM_TEXT_NEW_WORKSPACE");
        bar.add(this.newWs);
        this.open = ToolBar.button("SEAMCAT_ICON_WORKSPACE_OPEN", "MENU_ITEM_TEXT_OPEN_WORKSPACE");
        bar.add(this.open);
        this.export = ToolBar.button("SEAMCAT_ICON_EXPORT_LIBRARY", "MENU_ITEM_TEXT_EXPORT_WORKSPACE");
        bar.add(this.export);
        this.duplicate = ToolBar.button("SEAMCAT_ICON_DUPLICATE", "MENU_ITEM_TEXT_DUPLICATE_WORKSPACE");
        bar.add(this.duplicate);
        return bar;
    }

    private void defaultToolBar() {
        this.export.setEnabled(false);
        this.duplicate.setEnabled(false);
        this.open.setEnabled(true);
        this.newWs.setEnabled(true);
    }

    public void updateEnablement(WorkspaceView view) {
        boolean enable = view != null;
        this.export.setEnabled(enable);
        this.duplicate.setEnabled(enable);
        this.open.setEnabled(true);
        this.newWs.setEnabled(true);
    }
}

