/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.compare;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.compare.JCheckBoxListPanel;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.display.NamedVectorResult;
import org.seamcat.presentation.display.VectorGroupResultType;
import org.seamcat.presentation.display.VectorPanel;
import org.seamcat.presentation.propagationtest.VectorHolder;

public class VectorGroupDialog
extends EscapeDialog {
    private VectorPanel vectorPanel;
    private DefaultListModel<JCheckBox> listModel;
    private VectorGroupResultType group;
    private String label;

    public VectorGroupDialog(VectorGroupResultType group) {
        this(group, "Events");
    }

    public VectorGroupDialog(VectorGroupResultType group, String label) {
        this.group = group;
        this.label = label;
        this.vectorPanel = new VectorPanel(this);
        this.vectorPanel.show((double[])null, "", "", label);
        this.listModel = new DefaultListModel();
        for (NamedVectorResult vector : group.getVectorGroup()) {
            this.listModel.addElement(new JCheckBox(vector.getName(), true));
        }
        this.setLayout(new BorderLayout());
        this.getContentPane().add((Component)new BorderPanel(new JCheckBoxListPanel(this.listModel, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VectorGroupDialog.this.renderVectors();
            }
        }), group.getName()), "West");
        this.getContentPane().add((Component)this.vectorPanel, "Center");
        this.setTitle(group.getName());
        JDialog.setDefaultLookAndFeelDecorated(true);
        this.pack();
        this.setLocationRelativeTo(MainWindow.getInstance());
        this.setVisible(true);
        this.renderVectors();
    }

    private void renderVectors() {
        ArrayList<VectorHolder> result = new ArrayList<VectorHolder>();
        for (int i = 0; i < this.group.getVectorGroup().size(); ++i) {
            if (!this.listModel.get(i).isSelected()) continue;
            NamedVectorResult v = this.group.getVectorGroup().get(i);
            VectorHolder holder = new VectorHolder();
            holder.setTitle(v.getName());
            holder.setData(v.getVector().asArray());
            result.add(holder);
        }
        this.vectorPanel.showL(result, "", this.group.getUnit(), this.label);
    }
}

