/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.compare;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.compare.JCheckBoxListPanel;
import org.seamcat.presentation.compare.XYElement;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.display.VectorPanel;
import org.seamcat.presentation.propagationtest.VectorHolder;

public class XYGroupDialog
extends EscapeDialog {
    private VectorPanel vectorPanel;
    private DefaultListModel<JCheckBox> listModel;
    private String label;
    private List<XYElement> xys;

    public XYGroupDialog(String title, String label, List<XYElement> xys) {
        this.label = label;
        this.xys = xys;
        this.vectorPanel = new VectorPanel(this);
        this.vectorPanel.show((double[])null, "", "", label);
        this.listModel = new DefaultListModel();
        for (XYElement elm : xys) {
            this.listModel.addElement(new JCheckBox(elm.toString(), true));
        }
        this.setLayout(new BorderLayout());
        this.getContentPane().add((Component)new BorderPanel(new JCheckBoxListPanel(this.listModel, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                XYGroupDialog.this.renderVectors();
            }
        }), "Generated Signals"), "West");
        this.getContentPane().add((Component)this.vectorPanel, "Center");
        this.setTitle(title);
        JDialog.setDefaultLookAndFeelDecorated(true);
        this.pack();
        this.setLocationRelativeTo(MainWindow.getInstance());
        this.setVisible(true);
        this.renderVectors();
    }

    private void renderVectors() {
        ArrayList<VectorHolder> result = new ArrayList<VectorHolder>();
        for (int i = 0; i < this.xys.size(); ++i) {
            if (this.listModel.get(i).isSelected()) {
                XYElement v = this.xys.get(i);
                VectorHolder holder = new VectorHolder();
                holder.setTitle(v.toString());
                double[] data = new double[v.getValues().size()];
                double[] sorted = new double[v.getValues().size()];
                holder.setData(data);
                holder.setIndexedData(sorted);
                holder.setSortedTitle(this.label);
                List<Point2D> value = v.getValues();
                for (int j = 0; j < value.size(); ++j) {
                    Point2D point = value.get(j);
                    holder.getSortedDistributions()[j] = point.getX();
                    holder.getData()[j] = point.getY();
                }
                holder.init();
                result.add(holder);
            }
            this.vectorPanel.showL(result, "", "dB", this.label);
        }
    }
}

