/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.events.MemoryStatusUpdatedEvent;
import org.seamcat.presentation.simulationview.outline.OutlinePanel;

public abstract class AbstractStatusPanel
extends JPanel {
    private static final int MEMORY_FACTOR = 1024;
    private JProgressBar currentProcess = new JProgressBar(0, OutlinePanel.maxProgressSteps);
    private JLabel currentProcessLabel = new JLabel("Current process:");
    protected JCheckBox debug = new JCheckBox("Debug");
    protected LayoutManager layout = new GridBagLayout();
    protected JProgressBar memoryUsage = new JProgressBar(0, 100);
    protected JLabel memoryUsageLabel = new JLabel("Memory usage:");
    private static DecimalFormat df;

    protected AbstractStatusPanel() {
        this.setLayout(this.layout);
        this.currentProcess.setStringPainted(true);
        this.memoryUsage.setStringPainted(true);
        this.memoryUsageLabel.setText("Use of allocated memory (max: " + (int)(Runtime.getRuntime().maxMemory() / 1024L) + " kb / allocated: " + (int)(Runtime.getRuntime().totalMemory() / 1024L) + " kb):");
        GridBagConstraints con = new GridBagConstraints();
        con.gridheight = 1;
        con.fill = 1;
        con.anchor = 17;
        con.gridx = 0;
        con.weightx = 1.0;
        ++con.gridy;
        con.gridwidth = 3;
        this.add((Component)this.currentProcessLabel, con);
        con.gridx = 0;
        con.weightx = 1.0;
        ++con.gridy;
        con.gridwidth = 3;
        this.add((Component)this.currentProcess, con);
        con.gridx = 0;
        con.weightx = 1.0;
        ++con.gridy;
        con.gridwidth = 3;
        this.add((Component)this.memoryUsageLabel, con);
        ++con.gridy;
        con.gridwidth = 3;
        this.add((Component)this.memoryUsage, con);
        ++con.gridy;
        con.gridx = 0;
        con.weightx = 0.5;
        con.gridwidth = 1;
        this.add(Box.createHorizontalGlue(), con);
        ++con.gridx;
        con.weightx = 1.0;
        this.add(Box.createHorizontalGlue(), con);
        ++con.gridx;
        this.add(Box.createHorizontalGlue(), con);
        EventBusFactory.getEventBus().subscribe(this);
    }

    protected void initialize(int maxCount) {
        this.currentProcess.setMaximum(maxCount);
        this.currentProcess.setValue(0);
    }

    public void increment() {
        int nextValue = this.currentProcess.getValue() + 1;
        this.set(nextValue);
        int maximum = this.currentProcess.getMaximum();
        if (maximum < nextValue) {
            this.finished();
        } else {
            double value = (double)nextValue * 100.0 / (double)maximum;
            String format = df.format(value) + "%";
            this.currentProcess.setString(format);
        }
    }

    protected void set(int current) {
        this.currentProcess.setValue(current);
    }

    protected void finished() {
        this.currentProcess.setValue(this.currentProcess.getMaximum() + 1);
    }

    static {
        new Thread("static memory monitor"){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            int memoryMax = (int)(Runtime.getRuntime().totalMemory() / 1024L);
                            int memoryUsageValue = memoryMax - (int)(Runtime.getRuntime().freeMemory() / 1024L);
                            String memoryStatusLabel = "Use of allocated memory (max: " + (int)(Runtime.getRuntime().maxMemory() / 1024L) + " kb / allocated: " + (int)(Runtime.getRuntime().totalMemory() / 1024L) + " kb (" + (int)(Runtime.getRuntime().totalMemory() / 1024L) / ((int)(Runtime.getRuntime().maxMemory() / 1024L) / 100) + " %)):";
                            EventBusFactory.getEventBus().publish(new MemoryStatusUpdatedEvent(memoryMax, memoryStatusLabel, memoryUsageValue));
                            Thread.sleep(1000L);
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        }.start();
        df = new DecimalFormat("#.##");
    }
}

