/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jfree.data.DomainOrder;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.xy.XYDataset;
import org.seamcat.function.MaskFunctionImpl;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.presentation.components.DiscreteFunctionTableModelAdapterInterface;

public class DiscreteFunction2TableModelAdapter
implements TableModel,
XYDataset,
DiscreteFunctionTableModelAdapterInterface {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private static final String[] COL_NAMES = new String[]{STRINGLIST.getString("FIRST_COLUMN_TITLE"), STRINGLIST.getString("SECOND_COLUMN_TITLE"), STRINGLIST.getString("THIRD_COLUMN_TITLE")};
    private static final int SERIES1 = 0;
    private static final String SERIES1_NAME = STRINGLIST.getString("FIRST_SERIES_TITLE");
    private static final int SERIES2 = 1;
    private static final String SERIES2_NAME = STRINGLIST.getString("SECOND_SERIES_TITLE");
    private final List<DatasetChangeListener> datasetChangeListeners = new ArrayList<DatasetChangeListener>();
    private DatasetGroup datasetGroup = new DatasetGroup();
    protected MaskFunctionImpl function;
    protected final DatasetChangeEvent stdDatasetChangeEvent = new DatasetChangeEvent(this, this);
    protected final TableModelEvent stdTableModelEvent = new TableModelEvent(this);
    protected final List<TableModelListener> tableModelListeners = new ArrayList<TableModelListener>();

    public DiscreteFunction2TableModelAdapter() {
        this(new MaskFunctionImpl());
    }

    public DiscreteFunction2TableModelAdapter(MaskFunctionImpl function) {
        this.function = function;
        this.ensureMinimumRows();
    }

    @Override
    public void addChangeListener(DatasetChangeListener datasetChangeListener) {
        if (!this.datasetChangeListeners.contains(datasetChangeListener)) {
            this.datasetChangeListeners.add(datasetChangeListener);
        }
    }

    @Override
    public void addRow() {
        this.addRow(true);
    }

    private void addRow(boolean fireChangeListeners) {
        List<Point2D> list = this.function.points();
        if (list != null && list.size() > 0) {
            Point2D lastPoint = list.get(list.size() - 1);
            this.function.addPoint(new Point2D(lastPoint.getX() + 1.0, lastPoint.getY()), this.function.getMask(lastPoint));
        } else {
            this.function.addPoint(new Point2D(0.0, 0.0), 1000.0);
        }
        if (fireChangeListeners) {
            this.fireChangeListeners();
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (!this.tableModelListeners.contains(l)) {
            this.tableModelListeners.add(l);
        }
    }

    @Override
    public void clear() {
        this.function.points().clear();
        this.fireChangeListeners();
    }

    @Override
    public void deleteRow(int row) {
        if (row >= 0 && row < this.getRowCount()) {
            this.function.points().remove(row);
            this.ensureMinimumRows();
            this.fireChangeListeners();
        }
    }

    private void ensureMinimumRows() {
        if (this.getRowCount() == 0) {
            this.addRow(false);
        }
    }

    public void fireChangeListeners() {
        for (TableModelListener tableModelListener : this.tableModelListeners) {
            tableModelListener.tableChanged(this.stdTableModelEvent);
        }
        for (DatasetChangeListener datasetChangeListener : this.datasetChangeListeners) {
            datasetChangeListener.datasetChanged(this.stdDatasetChangeEvent);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Double.class;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COL_NAMES[columnIndex];
    }

    public MaskFunctionImpl getDiscreteFunction2() {
        return this.function;
    }

    @Override
    public DomainOrder getDomainOrder() {
        return DomainOrder.NONE;
    }

    @Override
    public MaskFunctionImpl getFunction() {
        this.sortPoints();
        return this.function;
    }

    @Override
    public void setFunction(Function points) {
        ArrayList<Point2D> points2d = new ArrayList<Point2D>();
        ArrayList<Double> mask = new ArrayList<Double>();
        MaskFunction maskFunction = null;
        if (points instanceof MaskFunction) {
            maskFunction = (MaskFunction)points;
        }
        for (Point2D point : points.getPoints()) {
            if (maskFunction != null) {
                mask.add(maskFunction.getMask(point));
            }
            points2d.add(point);
        }
        this.setDiscreteFunction2((MaskFunctionImpl)Factory.functionFactory().maskFunction(points2d, mask));
    }

    @Override
    public DatasetGroup getGroup() {
        return this.datasetGroup;
    }

    @Override
    public int getItemCount(int series) {
        return this.function.points().size();
    }

    @Override
    public int getRowCount() {
        return this.function.points().size();
    }

    @Override
    public int getSeriesCount() {
        return 2;
    }

    @Override
    public Comparable getSeriesKey(int arg0) {
        return this.getSeriesName(arg0);
    }

    public String getSeriesName(int series) {
        switch (series) {
            case 0: {
                return SERIES1_NAME;
            }
            case 1: {
                return SERIES2_NAME;
            }
        }
        throw new IllegalArgumentException("Illegal series index");
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Double value;
        switch (columnIndex) {
            case 0: {
                value = this.function.points().get(rowIndex).getX();
                break;
            }
            case 1: {
                value = this.function.points().get(rowIndex).getY();
                break;
            }
            case 2: {
                value = this.function.getMask(this.function.points().get(rowIndex));
                break;
            }
            default: {
                throw new IllegalArgumentException("Point only has three columns");
            }
        }
        return value;
    }

    @Override
    public Number getX(int arg0, int arg1) {
        return this.getXValue(arg0, arg1);
    }

    @Override
    public double getXValue(int series, int item) {
        if (series == 0 || series == 1) {
            return this.function.points().get(item).getX();
        }
        throw new IllegalArgumentException("Illegal series");
    }

    @Override
    public Number getY(int arg0, int arg1) {
        return this.getYValue(arg0, arg1);
    }

    @Override
    public double getYValue(int series, int item) {
        switch (series) {
            case 0: {
                return this.function.points().get(item).getY();
            }
            case 1: {
                Point2D p = this.function.points().get(item);
                Double mask = this.function.getMask(p);
                if (mask == null) {
                    mask = 1000.0;
                }
                return p.getY() + Mathematics.linear2dB(1000.0 / mask);
            }
        }
        throw new IllegalArgumentException("Illegal series");
    }

    @Override
    public int indexOf(Comparable ser) {
        if (ser.equals(SERIES1_NAME)) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void removeChangeListener(DatasetChangeListener datasetChangeListener) {
        this.datasetChangeListeners.remove(datasetChangeListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tableModelListeners.remove(l);
    }

    public void setDiscreteFunction2(MaskFunctionImpl function) {
        this.function = (MaskFunctionImpl)Factory.functionFactory().maskFunction(function);
        this.ensureMinimumRows();
        this.sortPoints();
        this.fireChangeListeners();
    }

    @Override
    public void setGroup(DatasetGroup datasetGroup) {
        this.datasetGroup = datasetGroup;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue instanceof Number) {
            Number number = (Number)aValue;
            Point2D old = this.function.points().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    this.function.updatePoint(old, new Point2D(number.doubleValue(), old.getY()));
                    break;
                }
                case 1: {
                    this.function.updatePoint(old, new Point2D(old.getX(), number.doubleValue()));
                    break;
                }
                case 2: {
                    this.function.setMask(old, number.doubleValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Point only has three columns");
                }
            }
            this.sortPoints();
            this.fireChangeListeners();
        } else if (aValue != null) {
            throw new IllegalArgumentException("TableModel only accepts instances of class Number [Passed argument was of type: " + aValue.getClass() + "]");
        }
    }

    public void sortPoints() {
        Collections.sort(this.function.points(), Point2D.X_COMPARATOR);
    }
}

