/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import org.seamcat.calculator.CalculatorInputField;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.presentation.components.UserDefinedFunctionPanel;

public class DiscreteFunctionPanel
extends JPanel {
    private static final int CONSTANT = 0;
    private static final String[] LAYOUTS = new String[]{"Constant", "User defined"};
    private static final ResourceBundle stringlist = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private static final int USERDEFINED = 1;
    private ConstantFunctionPanel constantFunctionPanel = new ConstantFunctionPanel();
    private CardLayout parametersLayout = new CardLayout();
    private JPanel parametersPanel = new JPanel(this.parametersLayout);
    private TypePanel typePanel = new TypePanel();
    private UserDefinedFunctionPanel userDefinitionPanel;

    public DiscreteFunctionPanel(String xAxis, String yAxis) {
        super(new BorderLayout());
        this.userDefinitionPanel = new UserDefinedFunctionPanel("User defined function", xAxis, yAxis);
        this.parametersPanel.add(LAYOUTS[0], this.constantFunctionPanel);
        this.parametersPanel.add(LAYOUTS[1], this.userDefinitionPanel);
        this.typePanel.btnConstant.doClick();
        this.add((Component)this.typePanel, "West");
        this.add((Component)this.parametersPanel, "Center");
    }

    public void setModel(DiscreteFunction f) {
        if (f.isConstant()) {
            this.constantFunctionPanel.setConstant(f.getConstant());
            this.typePanel.setSelectedButton(0);
        } else {
            this.userDefinitionPanel.setDiscreteFunction(f);
            this.typePanel.setSelectedButton(1);
        }
    }

    public DiscreteFunction getModel() {
        if (this.typePanel.getSelectedButton() == 0) {
            return new DiscreteFunction(this.constantFunctionPanel.getConstant());
        }
        return this.userDefinitionPanel.getDiscreteFunction();
    }

    private class TypePanel
    extends JPanel {
        private JRadioButton btnConstant = new JRadioButton(DiscreteFunctionPanel.access$100().getString("FUNCTION_CONSTANT"));
        private JRadioButton btnUserDefined = new JRadioButton(DiscreteFunctionPanel.access$100().getString("FUNCTION_USERDEFINED"));
        private int selectedButton = 0;

        public TypePanel() {
            ButtonGroup buttonGroupType = new ButtonGroup();
            buttonGroupType.add(this.btnConstant);
            buttonGroupType.add(this.btnUserDefined);
            this.btnConstant.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TypePanel.this.btnConstantActionPerformed(evt);
                }
            });
            this.btnUserDefined.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TypePanel.this.btnUserDefinedActionPerformed(evt);
                }
            });
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.btnConstant);
            this.add(this.btnUserDefined);
            this.setBorder(new TitledBorder("Type"));
        }

        private void btnConstantActionPerformed(ActionEvent e) {
            if (this.selectedButton != 0) {
                DiscreteFunctionPanel.this.constantFunctionPanel.clear();
                this.setSelectedButton(0);
            }
        }

        private void btnUserDefinedActionPerformed(ActionEvent e) {
            if (this.selectedButton != 1) {
                DiscreteFunctionPanel.this.userDefinitionPanel.clear();
                this.setSelectedButton(1);
            }
        }

        public int getSelectedButton() {
            return this.selectedButton;
        }

        public void setSelectedButton(int button) {
            this.selectedButton = button;
            switch (button) {
                case 0: {
                    this.btnConstant.setSelected(true);
                    this.btnConstant.requestFocus();
                    DiscreteFunctionPanel.this.parametersLayout.show(DiscreteFunctionPanel.this.parametersPanel, LAYOUTS[0]);
                    break;
                }
                case 1: {
                    this.btnUserDefined.setSelected(true);
                    this.btnUserDefined.requestFocus();
                    DiscreteFunctionPanel.this.parametersLayout.show(DiscreteFunctionPanel.this.parametersPanel, LAYOUTS[1]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal button state");
                }
            }
        }
    }

    private class ConstantFunctionPanel
    extends JPanel {
        private JFormattedTextField tfConstant;

        public ConstantFunctionPanel() {
            super(new FlowLayout(0));
            this.tfConstant = new CalculatorInputField(0.0);
            JLabel lblConstant = new JLabel(stringlist.getString("FUNCTION_CONSTANT"));
            lblConstant.setLabelFor(this.tfConstant);
            this.add(lblConstant);
            this.add(this.tfConstant);
            this.setBorder(new TitledBorder("Parameters"));
        }

        public void clear() {
            this.setConstant(30.0);
        }

        public double getConstant() {
            return ((Number)this.tfConstant.getValue()).doubleValue();
        }

        public void setConstant(double constant) {
            this.tfConstant.setValue(constant);
        }
    }
}

