/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.PolarChartPanel;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.PolarAxisLocation;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.renderer.DefaultPolarItemRenderer;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.TextAnchor;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.presentation.AntennaPatterns;
import org.seamcat.presentation.ChartSaver;
import org.seamcat.presentation.components.DiscreteFunctionPlot;
import org.seamcat.presentation.components.DiscreteFunctionTableModelAdapter;

public class DiscreteFunctionPolarPlot
extends DiscreteFunctionPlot {
    private final PolarChartPanel polarChartPanel;
    private JFreeChart polarChart;
    private XYSeriesCollection result;
    private DiscreteFunctionTableModelAdapter dataset;
    private AntennaPatterns type;

    public DiscreteFunctionPolarPlot(DiscreteFunctionTableModelAdapter dataset, AntennaPatterns type) {
        this.setLayout(new BorderLayout());
        this.type = type;
        this.dataset = dataset;
        this.result = new XYSeriesCollection();
        PolarPlot plot = new PolarPlot(this.result, new NumberAxis(), new DefaultPolarItemRenderer()){

            @Override
            protected List refreshAngleTicks() {
                int delta = (int)this.getAngleTickUnit().getSize();
                switch (DiscreteFunctionPolarPlot.this.type) {
                    case VERTICAL: {
                        return DiscreteFunctionPolarPlot.this.verticalTicks(delta);
                    }
                    case SPHERICAL: {
                        return DiscreteFunctionPolarPlot.this.sphericalTicks(delta);
                    }
                }
                return DiscreteFunctionPolarPlot.this.horizontalTicks(delta);
            }
        };
        plot.setAngleTickUnit(new NumberTickUnit(15.0));
        switch (type) {
            case SPHERICAL: {
                plot.setAxisLocation(PolarAxisLocation.NORTH_RIGHT);
            }
        }
        this.polarChart = new JFreeChart(plot);
        dataset.addChangeListener(this);
        this.polarChartPanel = new PolarChartPanel(this.polarChart);
        this.polarChartPanel.setMouseZoomable(true, true);
        this.polarChartPanel.setPreferredSize(new Dimension(800, 600));
        this.polarChart.removeLegend();
        PolarPlot pp = (PolarPlot)this.polarChart.getPlot();
        pp.getAxis().setTickLabelsVisible(true);
        pp.getAxis().setVerticalTickLabels(true);
        this.add((Component)this.polarChartPanel, "Center");
        dataset.fireChangeListeners();
    }

    private void shiftAndRotateCoordinates() {
        XYSeries series = new XYSeries((Comparable)((Object)"0"));
        Bounds bounds = this.type.getBounds();
        DiscreteFunction function = this.dataset.getFunction();
        Bounds functionBounds = function.getBounds();
        ArrayList<Point2D> allAngles = new ArrayList<Point2D>();
        int i = (int)bounds.getMin();
        while ((double)i < bounds.getMax()) {
            if (functionBounds.contains(i)) {
                allAngles.add(new Point2D(i, function.evaluate(i)));
            }
            ++i;
        }
        for (Point2D point : allAngles) {
            series.add(this.rotate(point.getX(), this.type), point.getY());
        }
        this.result.removeAllSeries();
        this.result.addSeries(series);
        this.polarChart.fireChartChanged();
    }

    private double rotate(double value, AntennaPatterns type) {
        switch (type) {
            case VERTICAL: {
                return (450.0 - value) % 360.0;
            }
        }
        return (360.0 - value) % 360.0;
    }

    private List<NumberTick> horizontalTicks(int delta) {
        ArrayList<NumberTick> ticks = new ArrayList<NumberTick>();
        for (int t = 0; t < 360; t += delta) {
            ticks.add(new NumberTick((Number)t, String.valueOf((int)this.rotate(t, AntennaPatterns.HORIZONTAL)), TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
        }
        return ticks;
    }

    private List<NumberTick> verticalTicks(int delta) {
        ArrayList<NumberTick> ticks = new ArrayList<NumberTick>();
        for (int t = 0; t < 360; t += delta) {
            double tp = this.rotate(t, AntennaPatterns.VERTICAL);
            if (!(tp <= 90.0) && !(tp >= 270.0)) continue;
            if (tp >= 270.0) {
                tp -= 360.0;
            }
            ticks.add(new NumberTick((Number)t, String.valueOf((int)tp), TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
        }
        return ticks;
    }

    @Override
    public void setAxisNames(String xAxis, String yAxis) {
    }

    private List<NumberTick> sphericalTicks(int delta) {
        ArrayList<NumberTick> ticks = new ArrayList<NumberTick>();
        for (int t = 0; t < 360; t += delta) {
            double tp = this.rotate(t, AntennaPatterns.SPHERICAL);
            if (!(tp <= 180.0)) continue;
            ticks.add(new NumberTick((Number)t, String.valueOf((int)tp), TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
        }
        return ticks;
    }

    @Override
    public void drawGraphToGraphics(Graphics2D g, Rectangle2D r) {
        this.polarChart.setBackgroundPaint(null);
        this.polarChart.draw(g, r);
    }

    @Override
    public DiscreteFunctionTableModelAdapter getDataSet() {
        return this.dataset;
    }

    @Override
    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        this.polarChart.getPlot().datasetChanged(datasetChangeEvent);
        this.shiftAndRotateCoordinates();
    }

    @Override
    public void saveChartImage() {
        ChartSaver.saveChart(this.polarChartPanel);
    }
}

