/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jfree.data.DomainOrder;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.xy.XYDataset;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.model.functions.Function;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.persistence.impl.FunctionMarshaller;
import org.seamcat.presentation.components.DiscreteFunctionTableModelAdapterInterface;

public class DiscreteFunctionTableModelAdapter
implements TableModel,
XYDataset,
DiscreteFunctionTableModelAdapterInterface {
    private static final int SERIES1 = 0;
    private String col1Name = "X";
    private String col2Name = "Y";
    private final List<DatasetChangeListener> datasetChangeListeners = new ArrayList<DatasetChangeListener>();
    private DatasetGroup datasetGroup = new DatasetGroup();
    private DiscreteFunction function;
    private final DatasetChangeEvent stdDatasetChangeEvent = new DatasetChangeEvent(this, this);
    private final TableModelEvent stdTableModelEvent = new TableModelEvent(this);
    private final List<TableModelListener> tableModelListeners = new ArrayList<TableModelListener>();

    public DiscreteFunctionTableModelAdapter() {
        this(new DiscreteFunction());
    }

    public DiscreteFunctionTableModelAdapter(DiscreteFunction function) {
        this.function = function;
        this.ensureMinimumRows();
    }

    @Override
    public void addChangeListener(DatasetChangeListener datasetChangeListener) {
        if (!this.datasetChangeListeners.contains(datasetChangeListener)) {
            this.datasetChangeListeners.add(datasetChangeListener);
        }
    }

    public void dispose() {
        this.datasetChangeListeners.clear();
        this.tableModelListeners.clear();
    }

    @Override
    public void addRow() {
        this.addRow(true);
    }

    private void addRow(boolean fireChangeListeners) {
        List<Point2D> list = this.function.points();
        if (list != null && list.size() > 0) {
            Point2D lastPoint = list.get(list.size() - 1);
            this.function.addPoint(new Point2D(lastPoint.getX() + 1.0, lastPoint.getY()));
        } else {
            this.function.addPoint(new Point2D(0.0, 0.0));
        }
        if (fireChangeListeners) {
            this.fireChangeListeners();
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (!this.tableModelListeners.contains(l)) {
            this.tableModelListeners.add(l);
        }
    }

    @Override
    public void clear() {
        this.function.points().clear();
        this.fireChangeListeners();
    }

    @Override
    public void deleteRow(int row) {
        if (row >= 0 && row < this.getRowCount()) {
            this.function.points().remove(row);
            this.ensureMinimumRows();
            this.fireChangeListeners();
        }
    }

    private void ensureMinimumRows() {
        if (this.getRowCount() == 0) {
            this.addRow(false);
        }
    }

    public void fireChangeListeners() {
        for (TableModelListener tableModelListener : this.tableModelListeners) {
            tableModelListener.tableChanged(this.stdTableModelEvent);
        }
        for (DatasetChangeListener datasetChangeListener : this.datasetChangeListeners) {
            datasetChangeListener.datasetChanged(this.stdDatasetChangeEvent);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Double.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return this.col1Name;
        }
        if (columnIndex == 1) {
            return this.col2Name;
        }
        throw new IllegalArgumentException("Point2D only has two columns <" + columnIndex + ">");
    }

    @Override
    public DomainOrder getDomainOrder() {
        return DomainOrder.ASCENDING;
    }

    @Override
    public DiscreteFunction getFunction() {
        return this.function;
    }

    @Override
    public void setFunction(Function points) {
        this.setDiscreteFunction(new DiscreteFunction(points.getPoints()));
    }

    @Override
    public DatasetGroup getGroup() {
        return this.datasetGroup;
    }

    @Override
    public int getItemCount(int series) {
        return this.function.points().size();
    }

    @Override
    public int getRowCount() {
        return this.function.points().size();
    }

    @Override
    public int getSeriesCount() {
        return 1;
    }

    @Override
    public Comparable<?> getSeriesKey(int arg0) {
        return this.getSeriesName(arg0);
    }

    public String getSeriesName(int series) {
        if (series == 0) {
            return "";
        }
        throw new IllegalArgumentException("Illegal series index");
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Double value;
        switch (columnIndex) {
            case 0: {
                value = this.function.points().get(rowIndex).getX();
                break;
            }
            case 1: {
                value = this.function.points().get(rowIndex).getY();
                break;
            }
            default: {
                throw new IllegalArgumentException("Point2D only has two columns");
            }
        }
        return value;
    }

    @Override
    public Number getX(int series, int item) {
        return this.getXValue(series, item);
    }

    @Override
    public double getXValue(int series, int item) {
        if (series == 0) {
            return this.function.points().get(item).getX();
        }
        throw new IllegalArgumentException("Illegal series");
    }

    @Override
    public Number getY(int series, int item) {
        return this.getYValue(series, item);
    }

    @Override
    public double getYValue(int series, int item) {
        switch (series) {
            case 0: {
                return this.function.points().get(item).getY();
            }
        }
        throw new IllegalArgumentException("Illegal series");
    }

    @Override
    public int indexOf(Comparable arg0) {
        return 0;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void removeChangeListener(DatasetChangeListener datasetChangeListener) {
        this.datasetChangeListeners.remove(datasetChangeListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tableModelListeners.remove(l);
    }

    public void setColumnName(int columnIndex, String name) {
        switch (columnIndex) {
            case 0: {
                this.col1Name = name;
                break;
            }
            case 1: {
                this.col2Name = name;
                break;
            }
            default: {
                throw new IllegalArgumentException("Point2D only has two columns <" + columnIndex + ">");
            }
        }
    }

    public void setDiscreteFunction(DiscreteFunction _function) {
        this.function = (DiscreteFunction)FunctionMarshaller.copy(_function);
        this.ensureMinimumRows();
        this.sortPoints();
        this.fireChangeListeners();
    }

    public void setPoints(List<Point2D> points) {
        this.function.setPoints(points);
        this.fireChangeListeners();
    }

    @Override
    public void setGroup(DatasetGroup datasetGroup) {
        this.datasetGroup = datasetGroup;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue instanceof Number) {
            Number number = (Number)aValue;
            Point2D old = this.function.points().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    this.function.points().set(rowIndex, new Point2D(number.doubleValue(), old.getY()));
                    break;
                }
                case 1: {
                    this.function.points().set(rowIndex, new Point2D(old.getX(), number.doubleValue()));
                    this.sortPoints();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Point2D only has two columns");
                }
            }
            this.fireChangeListeners();
        } else if (aValue != null) {
            throw new IllegalArgumentException("TableModel only accepts instances of class Number (Input was: " + aValue.getClass().getName() + ")");
        }
    }

    public void sortPoints() {
        Collections.sort(this.function.points(), Point2D.X_COMPARATOR);
    }
}

