/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetChangeEvent;
import org.seamcat.presentation.ChartSaver;
import org.seamcat.presentation.components.DiscreteFunctionGraph;
import org.seamcat.presentation.components.DiscreteFunctionPlot;
import org.seamcat.presentation.components.DiscreteFunctionTableModelAdapter;

public class DiscreteFunctionXYPlot
extends DiscreteFunctionPlot {
    private final ChartPanel xyChartPanel;
    private JFreeChart xyChart;
    private DiscreteFunctionTableModelAdapter dataset;

    public DiscreteFunctionXYPlot(DiscreteFunctionTableModelAdapter dataset, String xCaption, String yCaption) {
        this.setLayout(new BorderLayout());
        this.dataset = dataset;
        String xx = xCaption == null ? "" : xCaption;
        String yy = yCaption == null ? "" : yCaption;
        dataset.setColumnName(0, xx);
        dataset.setColumnName(1, yy);
        this.xyChart = ChartFactory.createXYLineChart("", xx, yy, dataset, PlotOrientation.VERTICAL, true, true, false);
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)this.xyChart.getXYPlot().getRenderer();
        renderer.setSeriesShapesVisible(0, true);
        renderer.setSeriesShapesFilled(0, true);
        dataset.addChangeListener(this);
        this.xyChartPanel = new ChartPanel(this.xyChart);
        this.xyChartPanel.setMouseZoomable(true, false);
        this.xyChartPanel.setPreferredSize(new Dimension(800, 600));
        DiscreteFunctionGraph.applyStyles(this.xyChartPanel, this.getFont(), false);
        this.setAxisResolution();
        this.add((Component)this.xyChartPanel, "Center");
        dataset.fireChangeListeners();
    }

    @Override
    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        this.xyChart.getPlot().datasetChanged(datasetChangeEvent);
        this.setAxisResolution();
    }

    @Override
    public void drawGraphToGraphics(Graphics2D g, Rectangle2D r) {
        this.xyChart.setBackgroundPaint(null);
        this.xyChart.draw(g, r);
    }

    @Override
    public void setAxisNames(String xAxis, String yAxis) {
        this.xyChart.getXYPlot().getDomainAxis().setLabel(xAxis);
        this.xyChart.getXYPlot().getRangeAxis().setLabel(yAxis);
    }

    private boolean singular(Range range) {
        return range == null || Math.abs(range.getUpperBound() - range.getLowerBound()) < 0.001;
    }

    public void setAxisResolution() {
        Range domain = this.xyChart.getXYPlot().getDomainAxis().getRange();
        Range range = this.xyChart.getXYPlot().getRangeAxis().getRange();
        if (this.singular(range)) {
            this.xyChart.getXYPlot().getRangeAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        } else {
            this.xyChart.getXYPlot().getRangeAxis().setStandardTickUnits(NumberAxis.createStandardTickUnits());
        }
        if (this.singular(domain)) {
            this.xyChart.getXYPlot().getDomainAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        } else {
            this.xyChart.getXYPlot().getDomainAxis().setStandardTickUnits(NumberAxis.createStandardTickUnits());
        }
    }

    @Override
    public DiscreteFunctionTableModelAdapter getDataSet() {
        return this.dataset;
    }

    @Override
    public void saveChartImage() {
        ChartSaver.saveChart(this.xyChartPanel);
    }
}

