/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.components.DiscreteFunctionGraph;
import org.seamcat.presentation.components.DiscreteFunctionTableModelAdapter;
import org.seamcat.presentation.components.SaveFileChooser;
import org.seamcat.presentation.display.ControlButtonPanel;
import org.seamcat.presentation.genericgui.GenericPanel;
import org.seamcat.presentation.genericgui.ItemChangedEvent;
import org.seamcat.presentation.genericgui.LongTaskFailable;
import org.seamcat.presentation.genericgui.LongTaskSwingExecutor;
import org.seamcat.presentation.genericgui.item.DoubleItem;
import org.seamcat.tabulardataio.FileDataIO;

public class GainPlotDialog
extends EscapeDialog {
    private DiscreteFunctionGraph graph;
    private DoubleItem frequency;
    private DoubleItem granularity;
    private DiscreteFunctionTableModelAdapter hor;
    private DiscreteFunctionTableModelAdapter ver;
    private DiscreteFunctionTableModelAdapter sph;
    private DiscreteFunction horizontal = new DiscreteFunction();
    private DiscreteFunction vertical = new DiscreteFunction();
    private DiscreteFunction spherical = new DiscreteFunction();
    private AntennaGainConfiguration configuration;

    public GainPlotDialog(AntennaGainConfiguration configuration) {
        super(MainWindow.getInstance(), "Antenna Gain Plot", true);
        this.configuration = configuration;
        GenericPanel panel = new GenericPanel();
        this.frequency = new DoubleItem();
        panel.addItem(this.frequency.label("Frequency").unit("MHz"));
        this.granularity = new DoubleItem();
        panel.addItem(this.granularity.label("Granularity"));
        panel.initializeWidgets();
        this.frequency.setValue(900.0);
        this.granularity.setValue(1.0);
        this.gainPlot();
        this.hor = new DiscreteFunctionTableModelAdapter(this.horizontal);
        this.ver = new DiscreteFunctionTableModelAdapter(this.vertical);
        this.sph = new DiscreteFunctionTableModelAdapter(this.spherical);
        this.graph = new DiscreteFunctionGraph(this.hor, this.ver, this.sph);
        JPanel right = new JPanel(new BorderLayout());
        right.add((Component)panel, "North");
        right.add((Component)this.createControls(), "Center");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new BorderPanel(this.graph, "Gain plot of " + configuration.description().name()), "Center");
        this.getContentPane().add((Component)right, "East");
        this.pack();
        EventBusFactory.getEventBus().subscribe(this);
    }

    @Override
    public boolean display() {
        boolean display = super.display();
        EventBusFactory.getEventBus().unsubscribe(this);
        return display;
    }

    @UIEventHandler
    public void handle(ItemChangedEvent event) {
        if (this.frequency.isRelevant() && this.granularity.isRelevant() && (event.getItem() == this.frequency || event.getItem() == this.granularity)) {
            this.frequency.setRelevant(false);
            this.granularity.setRelevant(false);
            LongTaskSwingExecutor.execute(new LongTaskFailable(){

                @Override
                public Window getOwner() {
                    return GainPlotDialog.this;
                }

                @Override
                public Object process() throws Exception {
                    GainPlotDialog.this.gainPlot();
                    return null;
                }

                @Override
                public void done(Object result) {
                    GainPlotDialog.this.hor.setDiscreteFunction(GainPlotDialog.this.horizontal);
                    GainPlotDialog.this.ver.setDiscreteFunction(GainPlotDialog.this.vertical);
                    GainPlotDialog.this.sph.setDiscreteFunction(GainPlotDialog.this.spherical);
                    GainPlotDialog.this.frequency.setRelevant(true);
                    GainPlotDialog.this.granularity.setRelevant(true);
                }

                @Override
                public void failed(Exception exception) {
                    DialogHelper.gainCalculationError(exception);
                    GainPlotDialog.this.horizontal = new DiscreteFunction();
                    GainPlotDialog.this.vertical = new DiscreteFunction();
                    GainPlotDialog.this.spherical = new DiscreteFunction();
                    this.done((Object)null);
                }
            });
        }
    }

    private ControlButtonPanel createControls() {
        return new ControlButtonPanel(this, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileDataIO fileIO = SaveFileChooser.chooseFile(GainPlotDialog.this.getParent());
                if (fileIO != null) {
                    DiscreteFunctionTableModelAdapter dataSet = GainPlotDialog.this.graph.getDataSet();
                    fileIO.saveFunction(dataSet.getFunction(), "Degree", "Gain (dBi)");
                }
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GainPlotDialog.this.graph.saveImage();
            }
        });
    }

    private void gainPlot() {
        LinkResult result = Factory.results().linkResult();
        result.setFrequency(this.frequency.getValue());
        AntennaResult x = result.rxAntenna();
        ArrayList<Point2D> hor = new ArrayList<Point2D>();
        ArrayList<Point2D> ver = new ArrayList<Point2D>();
        ArrayList<Point2D> sph = new ArrayList<Point2D>();
        x.setElevation(0.0);
        for (double azi = 0.0; azi <= 360.0; azi += this.granularity.getValue().doubleValue()) {
            x.setAzimuth(azi);
            double value = this.configuration.evaluate(result, x);
            double v = Math.rint(azi * 10.0) / 10.0;
            hor.add(new Point2D(v, value));
            if (!(azi <= 180.0)) continue;
            sph.add(new Point2D(v, value));
        }
        x.setAzimuth(0.0);
        for (double ele = -90.0; ele <= 90.0; ele += this.granularity.getValue().doubleValue()) {
            x.setElevation(ele);
            ver.add(new Point2D(Math.rint(ele * 10.0) / 10.0, this.configuration.evaluate(result, x)));
        }
        this.horizontal = (DiscreteFunction)Factory.functionFactory().discreteFunction(hor);
        this.vertical = (DiscreteFunction)Factory.functionFactory().discreteFunction(ver);
        this.spherical = (DiscreteFunction)Factory.functionFactory().discreteFunction(sph);
    }
}

