/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.awt.GridLayout;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.seamcat.presentation.genericgui.WidgetAndKind;
import org.seamcat.presentation.genericgui.WidgetKind;
import org.seamcat.presentation.genericgui.item.ComponentWrapperItem;
import org.seamcat.presentation.resources.ImageLoader;

public class GenericLibraryImportExportResetWidget
extends ComponentWrapperItem {
    private JButton anImport;
    private JButton export;
    private JButton restore;
    ImageIcon importIcon = new ImageIcon(ImageLoader.class.getResource("import_16x16.png"));
    ImageIcon exportIcon = new ImageIcon(ImageLoader.class.getResource("export_16x16.png"));
    ImageIcon restoreIcon = new ImageIcon(ImageLoader.class.getResource("restore_default_16x16.png"));

    public GenericLibraryImportExportResetWidget() {
        super(new WidgetAndKind[0]);
        JPanel buttons = new JPanel(new GridLayout(1, 3));
        this.anImport = new JButton(this.importIcon);
        this.anImport.setToolTipText("Import");
        buttons.add(this.anImport);
        this.export = new JButton(this.exportIcon);
        this.export.setToolTipText("Export");
        buttons.add(this.export);
        this.restore = new JButton(this.restoreIcon);
        this.restore.setToolTipText("Restore default values");
        buttons.add(this.restore);
        this.addWidgetAndKind(new WidgetAndKind(new JLabel("Library"), WidgetKind.LABEL));
        this.addWidgetAndKind(new WidgetAndKind(buttons, WidgetKind.VALUE));
    }

    public void addExportHandler(ActionListener listener) {
        this.export.addActionListener(listener);
    }

    public void addImportHandler(ActionListener listener) {
        this.anImport.addActionListener(listener);
    }

    public void addRestoreHandle(ActionListener listener) {
        this.restore.addActionListener(listener);
    }

    public void dispose() {
        for (ActionListener listener : this.export.getActionListeners()) {
            this.export.removeActionListener(listener);
        }
        for (ActionListener listener : this.anImport.getActionListeners()) {
            this.anImport.removeActionListener(listener);
        }
    }

    public void setGlobalRelevance(boolean relevance) {
        this.anImport.setEnabled(relevance);
        this.export.setEnabled(relevance);
        this.restore.setEnabled(relevance);
    }
}

