/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.seamcat.cdma.CDMALinkLevelData;
import org.seamcat.function.BitRateMappingImpl;
import org.seamcat.function.BlockingMaskImpl;
import org.seamcat.function.EmissionMaskImpl;
import org.seamcat.function.IntermodulationRejectionMaskImpl;
import org.seamcat.model.functions.BitRateMapping;
import org.seamcat.model.functions.BlockingMask;
import org.seamcat.model.functions.EmissionMask;
import org.seamcat.model.functions.IntermodulationRejectionMask;
import org.seamcat.model.types.Configuration;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.components.NavigateButtonPanel;

public abstract class GenericListDetailDialog<T>
extends EscapeDialog {
    private final JList list;
    private JComponent detail;
    private JPanel detailPanel = new JPanel(new BorderLayout());

    public GenericListDetailDialog(JFrame parent, String windowTitle, Iterable<T> elements) {
        super((Frame)parent, true);
        this.setTitle(windowTitle);
        this.list = new JList();
        DefaultListModel<T> model = new DefaultListModel<T>();
        this.list.setModel(model);
        for (T element : elements) {
            model.addElement(element);
        }
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting()) {
                    GenericListDetailDialog.this.selectedElement(GenericListDetailDialog.this.list.getSelectedValue());
                }
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        JScrollPane pane = new JScrollPane();
        pane.setViewportView(this.list);
        JSplitPane jSplitPane = new JSplitPane(1, true);
        jSplitPane.add(pane);
        jSplitPane.add(new JScrollPane(this.detailPanel));
        jSplitPane.setDividerLocation(200);
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.getContentPane().add((Component)new NavigateButtonPanel(this), "South");
        this.setSize(new Dimension(800, 600));
        this.setLocationRelativeTo(parent);
        this.list.setSelectedIndex(0);
    }

    public T getSelectedValue() {
        Object selectedValue = this.list.getSelectedValue();
        if (selectedValue instanceof Configuration) {
            return (T)((Configuration)selectedValue).copy();
        }
        if (selectedValue instanceof CDMALinkLevelData) {
            CDMALinkLevelData value = (CDMALinkLevelData)selectedValue;
            return (T)new CDMALinkLevelData(value.getModel());
        }
        if (selectedValue instanceof EmissionMask) {
            EmissionMaskImpl em = (EmissionMaskImpl)selectedValue;
            return (T)em.copy();
        }
        if (selectedValue instanceof BlockingMask) {
            BlockingMaskImpl bm = (BlockingMaskImpl)selectedValue;
            return (T)bm.copy();
        }
        if (selectedValue instanceof IntermodulationRejectionMask) {
            IntermodulationRejectionMaskImpl ir = (IntermodulationRejectionMaskImpl)selectedValue;
            return (T)ir.copy();
        }
        if (selectedValue instanceof BitRateMapping) {
            BitRateMappingImpl bm = (BitRateMappingImpl)selectedValue;
            return (T)bm.copy();
        }
        throw new RuntimeException("unsupported generic type: " + selectedValue);
    }

    public void setDetail(JComponent detail) {
        if (this.detail != null) {
            this.detailPanel.remove(this.detail);
        }
        this.detail = detail;
        this.detailPanel.add(detail);
        this.detailPanel.updateUI();
    }

    public abstract void selectedElement(T var1);
}

