/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.seamcat.help.SeamcatHelpResolver;
import org.seamcat.presentation.EscapeDialog;

public class NavigateButtonPanel
extends JPanel {
    protected static final ResourceBundle stringlist = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    protected final JButton btnCancel;
    protected final JButton btnHelp;
    protected final JButton btnOk;
    private EscapeDialog owner;

    public NavigateButtonPanel(EscapeDialog owner) {
        this(owner, false);
    }

    public NavigateButtonPanel(EscapeDialog owner, boolean displayHelp) {
        this(owner, displayHelp, true, stringlist.getString("BTN_CAPTION_OK"));
    }

    public NavigateButtonPanel(EscapeDialog owner, boolean displayHelp, String okText) {
        this(owner, displayHelp, true, okText);
    }

    public NavigateButtonPanel(EscapeDialog owner, boolean displayHelp, boolean displayCancel, String okText) {
        this.owner = owner;
        this.btnOk = new JButton(okText);
        this.btnCancel = new JButton(stringlist.getString("BTN_CAPTION_CANCEL"));
        this.btnHelp = new JButton(stringlist.getString("BTN_CAPTION_HELP"));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigateButtonPanel.this.btnOkActionPerformed();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigateButtonPanel.this.btnCancelActionPerformed();
            }
        });
        this.btnHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigateButtonPanel.this.btnHelpActionPerformed();
            }
        });
        this.add(this.btnOk);
        if (displayCancel) {
            this.add(this.btnCancel);
        }
        if (displayHelp) {
            this.add(this.btnHelp);
        }
    }

    public void btnCancelActionPerformed() {
        this.owner.setAccept(false);
        this.owner.setVisible(false);
    }

    public void btnHelpActionPerformed() {
        SeamcatHelpResolver.showHelp(this.owner);
    }

    public void btnOkActionPerformed() {
        this.owner.setAccept(true);
        this.owner.setVisible(false);
    }
}

