/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FilenameUtils;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.SeamcatJFileChooser;
import org.seamcat.tabulardataio.FileDataIO;
import org.seamcat.tabulardataio.FileFormat;
import org.seamcat.tabulardataio.TabularDataFactory;

public class SaveFileChooser {
    public static FileDataIO chooseFile(Component parent) {
        SeamcatJFileChooser chooser = new SeamcatJFileChooser();
        FileDataIO result = null;
        chooser.resetChoosableFileFilters();
        chooser.setAcceptAllFileFilterUsed(false);
        for (FileFormat fileFormat : TabularDataFactory.allFormats()) {
            chooser.addChoosableFileFilter(new FileNameExtensionFilter(fileFormat.getName(), fileFormat.getExtension()));
        }
        if (((JFileChooser)chooser).showSaveDialog(parent) == 0) {
            File selectedFile = chooser.getSelectedFile();
            FileFilter filter = chooser.getFileFilter();
            if (filter != null && filter instanceof FileNameExtensionFilter) {
                String wantedExtension = ((FileNameExtensionFilter)filter).getExtensions()[0];
                if (!selectedFile.getName().endsWith("." + wantedExtension)) {
                    selectedFile = new File(selectedFile.getAbsolutePath() + "." + wantedExtension);
                }
            }
            if (TabularDataFactory.findByFile(selectedFile) != null) {
                result = new FileDataIO();
                result.setFile(selectedFile);
            } else {
                DialogHelper.generalSeamcatError("Unsupported file format: " + FilenameUtils.getExtension(selectedFile.getName()));
            }
        }
        return result;
    }
}

