/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.seamcat.presentation.components.DiscreteFunction2TableModelAdapter;
import org.seamcat.presentation.components.DiscreteFunctionTableModelAdapter;
import org.seamcat.presentation.components.StairDistributionTableModelAdapter;

public class SeamcatTable
extends JTable {
    private SeamcatTableLastCellAction lastCellAction;

    public SeamcatTable(TableModel dm) {
        super(dm);
        this.init();
        if (dm instanceof DiscreteFunctionTableModelAdapter) {
            this.addSeamcatTableLastCellAction(new SeamcatTableLastCellAction(){

                @Override
                public void tabActionPerformedOnLastCell() {
                    ((DiscreteFunctionTableModelAdapter)SeamcatTable.this.getModel()).addRow();
                }
            });
        } else if (dm instanceof DiscreteFunction2TableModelAdapter) {
            this.addSeamcatTableLastCellAction(new SeamcatTableLastCellAction(){

                @Override
                public void tabActionPerformedOnLastCell() {
                    ((DiscreteFunction2TableModelAdapter)SeamcatTable.this.getModel()).addRow();
                }
            });
        } else if (dm instanceof StairDistributionTableModelAdapter) {
            this.addSeamcatTableLastCellAction(new SeamcatTableLastCellAction(){

                @Override
                public void tabActionPerformedOnLastCell() {
                    ((StairDistributionTableModelAdapter)SeamcatTable.this.getModel()).addRow();
                }
            });
        }
    }

    public void addSeamcatTableLastCellAction(SeamcatTableLastCellAction stca) {
        this.lastCellAction = stca;
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        boolean res = super.editCellAt(row, column, e);
        Component c = this.getEditorComponent();
        if (c instanceof JTextComponent) {
            ((JTextComponent)c).selectAll();
            if (this.getColumnClass(column) == Double.class && c instanceof JFormattedTextField) {
                ((JFormattedTextField)c).setFocusLostBehavior(0);
            }
        }
        return res;
    }

    private void init() {
        String actionName = "selectNextColumnCell";
        final Action tabAction = this.getActionMap().get(actionName);
        AbstractAction myAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SeamcatTable.this.isLastCell()) {
                    try {
                        SeamcatTable.this.lastCellAction.tabActionPerformedOnLastCell();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                tabAction.actionPerformed(e);
            }
        };
        this.getActionMap().put(actionName, myAction);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(false);
    }

    public boolean isLastCell() {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        int selectedRow = this.getSelectedRow();
        int selectedCol = this.getSelectedColumn();
        return rows == selectedRow + 1 && cols == selectedCol + 1;
    }

    private static interface SeamcatTableLastCellAction {
        public void tabActionPerformedOnLastCell();
    }
}

