/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.seamcat.presentation.ChartSaver;
import org.seamcat.presentation.components.StairDistributionTableModelAdapter;

public class StairDistributionGraph
extends JPanel
implements DatasetChangeListener {
    private final ChartPanel chartPanel;
    private JFreeChart chart;

    public StairDistributionGraph(StairDistributionTableModelAdapter dataset) {
        super(new GridLayout());
        CategoryDataset dset = dataset.getCategoryDS();
        this.chart = ChartFactory.createBarChart(null, "Value", "Cumulative probability", dset, PlotOrientation.VERTICAL, false, true, false);
        dset.addChangeListener(this);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setMouseZoomable(true, false);
        this.chartPanel.getChart().setBackgroundPaint(this.getBackground());
        CategoryPlot p = this.chartPanel.getChart().getCategoryPlot();
        p.setBackgroundPaint(Color.white);
        p.setRangeGridlinePaint(this.getForeground());
        p.setDomainGridlinePaint(this.getForeground());
        p.getDomainAxis().setTickLabelFont(this.getFont());
        p.getDomainAxis().setTickLabelPaint(this.chartPanel.getForeground());
        p.getDomainAxis().setLabelFont(this.getFont());
        p.getDomainAxis().setLabelPaint(this.chartPanel.getForeground());
        p.getRangeAxis().setTickLabelFont(this.getFont());
        p.getRangeAxis().setTickLabelPaint(this.chartPanel.getForeground());
        p.getRangeAxis().setLabelFont(this.getFont());
        p.getRangeAxis().setLabelPaint(this.chartPanel.getForeground());
        this.alignTicks();
        this.add(this.chartPanel);
    }

    @Override
    public void datasetChanged(DatasetChangeEvent dce) {
        this.chart.getPlot().datasetChanged(dce);
        this.alignTicks();
    }

    private void alignTicks() {
        Range range = this.chart.getCategoryPlot().getDataRange(this.chart.getCategoryPlot().getRangeAxis());
        if (range == null || Math.abs(range.getUpperBound() - range.getLowerBound()) < 0.001) {
            this.chart.getCategoryPlot().getRangeAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        } else {
            this.chart.getCategoryPlot().getRangeAxis().setStandardTickUnits(NumberAxis.createStandardTickUnits());
        }
    }

    public void drawGraphToGraphics(Graphics2D g, Rectangle2D r) {
        this.chart.setBackgroundPaint(null);
        this.chart.draw(g, r);
    }

    public void saveChartImage() {
        ChartSaver.saveChart(this.chartPanel);
    }
}

