/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.model.distributions.StairDistributionImpl;
import org.seamcat.model.geometry.Point2D;

public class StairDistributionTableModelAdapter
implements TableModel {
    private String col1Name;
    private String col2Name;
    private List<Point2D> points = new ArrayList<Point2D>();
    private CategoryDatasetImpl categoryDS = new CategoryDatasetImpl();
    private TableModelEvent stdTableModelEvent = new TableModelEvent(this);
    private List<TableModelListener> tableModelListeners = new ArrayList<TableModelListener>();

    public StairDistributionTableModelAdapter() {
        this(new Point2D[0]);
    }

    public StairDistributionTableModelAdapter(Point2D[] _points) {
        Collections.addAll(this.points, _points);
        this.ensureMinimumRows();
        this.col1Name = "Value";
        this.col2Name = "Cum. Prob.";
    }

    public void addRow() {
        this.addRow(true);
    }

    private void addRow(boolean fireChangeListeners) {
        this.points.add(new Point2D(0.0, 0.0));
        if (fireChangeListeners) {
            this.fireChangeListeners();
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (!this.tableModelListeners.contains(l)) {
            this.tableModelListeners.add(l);
        }
    }

    public void clear() {
        this.points.clear();
        this.fireChangeListeners();
    }

    public void deleteRow(int row) {
        if (row >= 0 && row < this.getRowCount()) {
            this.points.remove(row);
            this.ensureMinimumRows();
            this.fireChangeListeners();
        }
    }

    private void ensureMinimumRows() {
        if (this.getRowCount() == 0) {
            this.addRow(false);
        }
    }

    public void fireChangeListeners() {
        for (TableModelListener listener : this.tableModelListeners) {
            listener.tableChanged(this.stdTableModelEvent);
        }
        this.categoryDS.fireChangeListeners();
    }

    public CategoryDataset getCategoryDS() {
        return this.categoryDS;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Double.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.col1Name;
            }
            case 1: {
                return this.col2Name;
            }
        }
        throw new IllegalArgumentException("Point2D only has two columns <" + columnIndex + ">");
    }

    public int getIndex(Double key) {
        int index = -1;
        int size = this.points.size();
        for (int x = 0; x < size; ++x) {
            if (new Double(this.points.get(x).getX()).compareTo(key) != 0) continue;
            index = x;
            break;
        }
        return index;
    }

    public Comparable<Double> getKey(int index) {
        return this.points.get(index).getX();
    }

    public Point2D[] getPoints() {
        return this.points.toArray(new Point2D[this.points.size()]);
    }

    public List<Point2D> getPointsList() {
        return this.points;
    }

    @Override
    public int getRowCount() {
        return this.points.size();
    }

    public Number getValue(int index) {
        return this.points.get(index).getY();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.points.get(rowIndex).getX();
            }
            case 1: {
                return this.points.get(rowIndex).getY();
            }
        }
        throw new IllegalArgumentException("Point2D only has two columns");
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tableModelListeners.remove(l);
    }

    public void setPoints(List<Point2D> _points) {
        this.points = _points;
        this.ensureMinimumRows();
        this.sortPoints();
        this.fireChangeListeners();
    }

    public void setPoints(StairDistributionImpl stairDist) {
        this.points.clear();
        DiscreteFunction cdf = (DiscreteFunction)stairDist.getCdf();
        for (Point2D d : cdf.points()) {
            this.points.add(d);
        }
        this.ensureMinimumRows();
        this.sortPoints();
        this.fireChangeListeners();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue instanceof Number) {
            Number number = (Number)aValue;
            switch (columnIndex) {
                case 0: {
                    Point2D old = this.points.get(rowIndex);
                    this.points.set(rowIndex, new Point2D(number.doubleValue(), old.getY()));
                    break;
                }
                case 1: {
                    Point2D old = this.points.get(rowIndex);
                    this.points.set(rowIndex, new Point2D(old.getX(), number.doubleValue()));
                    this.sortPoints();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Point2D only has two columns");
                }
            }
        } else {
            throw new IllegalArgumentException("TableModel only accepts instances of class Number");
        }
        this.fireChangeListeners();
    }

    public void sortPoints() {
        Collections.sort(this.points, Point2D.Y_COMPARATOR);
    }

    private class CategoryDatasetImpl
    implements CategoryDataset {
        private List<Double> columnKeys = new ArrayList<Double>();
        private List<DatasetChangeListener> datasetChangeListeners = new ArrayList<DatasetChangeListener>();
        private DatasetGroup datasetGroup = new DatasetGroup();
        private List<Integer> rowKeys = new ArrayList<Integer>(1);
        private DatasetChangeEvent stdDatasetChangeEvent = new DatasetChangeEvent(this, this);

        public CategoryDatasetImpl() {
            this.rowKeys.add(0);
            this.updateColumnKeys();
        }

        @Override
        public void addChangeListener(DatasetChangeListener datasetChangeListener) {
            if (!this.datasetChangeListeners.contains(datasetChangeListener)) {
                this.datasetChangeListeners.add(datasetChangeListener);
            }
        }

        public void fireChangeListeners() {
            this.updateColumnKeys();
            for (DatasetChangeListener listener : this.datasetChangeListeners) {
                listener.datasetChanged(this.stdDatasetChangeEvent);
            }
        }

        @Override
        public int getColumnCount() {
            return StairDistributionTableModelAdapter.this.points.size();
        }

        @Override
        public int getColumnIndex(Comparable key) {
            return this.columnKeys.indexOf(key);
        }

        @Override
        public Comparable<Double> getColumnKey(int column) {
            return ((Point2D)StairDistributionTableModelAdapter.this.points.get(column)).getX();
        }

        @Override
        public List<Double> getColumnKeys() {
            return this.columnKeys;
        }

        @Override
        public DatasetGroup getGroup() {
            return this.datasetGroup;
        }

        @Override
        public int getRowCount() {
            return 1;
        }

        @Override
        public int getRowIndex(Comparable key) {
            return this.rowKeys.indexOf(key);
        }

        @Override
        public Comparable<Integer> getRowKey(int row) {
            return this.rowKeys.get(row);
        }

        @Override
        public List<Integer> getRowKeys() {
            return this.rowKeys;
        }

        @Override
        public Number getValue(Comparable rowKey, Comparable colKey) {
            return this.getValue(this.getRowIndex(rowKey), this.getColumnIndex(colKey));
        }

        @Override
        public Number getValue(int row, int column) {
            return ((Point2D)StairDistributionTableModelAdapter.this.points.get(column)).getY();
        }

        @Override
        public void removeChangeListener(DatasetChangeListener datasetChangeListener) {
            this.datasetChangeListeners.remove(datasetChangeListener);
        }

        @Override
        public void setGroup(DatasetGroup datasetGroup) {
            this.datasetGroup = datasetGroup;
        }

        private void updateColumnKeys() {
            this.columnKeys.clear();
            int size = StairDistributionTableModelAdapter.this.points.size();
            for (int x = 0; x < size; ++x) {
                this.columnKeys.add((Double)this.getColumnKey(x));
            }
        }
    }
}

