/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.systems.aggregate.AggregateSystemPlugin;
import org.seamcat.model.types.Description;
import org.seamcat.presentation.systems.Helper;
import org.seamcat.presentation.systems.SystemListItem;
import org.seamcat.util.StringHelper;

public class SystemTree
extends JTree {
    private SelectionListener selectionListener;
    private ContextMenuProvider contextMenuProvider;
    private DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode());

    public SystemTree() {
        this.setModel(this.treeModel);
        this.getSelectionModel().setSelectionMode(1);
        this.setRootVisible(false);
        this.addTreeSelectionListener(new ThisTreeSelectionListener());
        this.addMouseListener(new ThisMouseListener());
    }

    public void setSystems(Collection<SystemListItem> systems) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
        rootNode.removeAllChildren();
        for (SystemListItem system : systems) {
            DefaultMutableTreeNode systemRoot = new DefaultMutableTreeNode(system);
            rootNode.add(systemRoot);
            SystemPlugin element = system.getSystemPlugin();
            if (!(element instanceof AggregateSystemPlugin)) continue;
            AggregateSystemPlugin plugin = (AggregateSystemPlugin)element;
            for (SystemPlugin systemPlugin : plugin.getComponents()) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(new SystemListItem(systemPlugin));
                systemRoot.add(node);
            }
        }
        this.treeModel.reload();
        if (systems.size() > 0) {
            TreePath pathToFirstRealNode = new TreePath(((DefaultMutableTreeNode)rootNode.getFirstChild()).getPath());
            this.setSelectionPath(pathToFirstRealNode);
        }
    }

    public List<SystemListItem> getSystems() {
        ArrayList<SystemListItem> systems = new ArrayList<SystemListItem>();
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
        Enumeration<TreeNode> topLevelNodeEnumeration = rootNode.children();
        while (topLevelNodeEnumeration.hasMoreElements()) {
            DefaultMutableTreeNode topLevelNode = (DefaultMutableTreeNode)topLevelNodeEnumeration.nextElement();
            SystemListItem system = (SystemListItem)topLevelNode.getUserObject();
            systems.add(system);
        }
        return systems;
    }

    public void addSystem(SystemListItem newSystem) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
        DefaultMutableTreeNode newSystemNode = new DefaultMutableTreeNode(newSystem);
        this.treeModel.insertNodeInto(newSystemNode, rootNode, rootNode.getChildCount());
        if (newSystem.getSystemPlugin() instanceof AggregateSystemPlugin) {
            for (SystemPlugin component : ((AggregateSystemPlugin)newSystem.getSystemPlugin()).getComponents()) {
                DefaultMutableTreeNode componentNode = new DefaultMutableTreeNode(new SystemListItem(component));
                this.treeModel.insertNodeInto(componentNode, newSystemNode, newSystemNode.getChildCount());
            }
        }
        this.setSelectionPath(new TreePath(newSystemNode.getPath()));
    }

    public void replaceSystemById(SystemListItem newSystem) {
        DefaultMutableTreeNode node = this.findNodeForSystemWithId(newSystem.getSystemPlugin().getUI().id());
        if (node == null) {
            throw new RuntimeException("Node not found");
        }
        node.setUserObject(newSystem);
    }

    public SystemListItem duplicateSystem(SystemListItem system) {
        DefaultMutableTreeNode node = this.findNode(system);
        List<String> siblingNames = this.getSiblingSystemNames(node);
        if (this.isAggregateSystem(node)) {
            SystemListItem model = this.getSelectedSystem();
            SystemListItem clone = this.cloneSystemListItem(model, siblingNames);
            AggregateSystemPlugin duplicateAggregate = (AggregateSystemPlugin)clone.getSystemPlugin();
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(clone);
            this.treeModel.insertNodeInto(newNode, rootNode, rootNode.getChildCount());
            for (SystemPlugin duplicateComponent : duplicateAggregate.getComponents()) {
                DefaultMutableTreeNode duplicateComponentNode = new DefaultMutableTreeNode(new SystemListItem(duplicateComponent));
                this.treeModel.insertNodeInto(duplicateComponentNode, newNode, newNode.getChildCount());
            }
            this.setSelectionPath(new TreePath(newNode.getPath()));
            return clone;
        }
        if (this.isComponentSystem(node)) {
            SystemListItem originalComponentListItem = this.getSelectedSystem();
            SystemListItem duplicateComponentListItem = this.cloneSystemListItem(originalComponentListItem, siblingNames);
            DefaultMutableTreeNode aggregateSystemNode = (DefaultMutableTreeNode)node.getParent();
            AggregateSystemPlugin aggregateSystem = (AggregateSystemPlugin)this.systemPluginInNode(aggregateSystemNode);
            aggregateSystem.addComponent(duplicateComponentListItem.getSystemPlugin());
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(duplicateComponentListItem);
            this.treeModel.insertNodeInto(newNode, aggregateSystemNode, aggregateSystemNode.getChildCount());
            this.setSelectionPath(new TreePath(newNode.getPath()));
            return duplicateComponentListItem;
        }
        SystemListItem model = this.getSelectedSystem();
        SystemListItem clone = this.cloneSystemListItem(model, siblingNames);
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(clone);
        this.treeModel.insertNodeInto(newNode, rootNode, rootNode.getChildCount());
        this.setSelectionPath(new TreePath(newNode.getPath()));
        return clone;
    }

    private List<String> getSiblingSystemNames(DefaultMutableTreeNode node) {
        ArrayList<String> accumulator = new ArrayList<String>();
        Enumeration<? extends TreeNode> e = node.getParent().children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode siblingNode = (DefaultMutableTreeNode)e.nextElement();
            SystemListItem siblingSystem = (SystemListItem)siblingNode.getUserObject();
            accumulator.add(siblingSystem.toString());
        }
        return accumulator;
    }

    private SystemListItem cloneSystemListItem(SystemListItem model, List<String> siblingNames) {
        String duplicatedName = StringHelper.getDuplicatedName(model.description().name(), siblingNames);
        Description name = Helper.changeName(model.description(), duplicatedName);
        return new SystemListItem(ProxyHelper.cloneSystemPlugin(model.getSystemPlugin(), name));
    }

    public void deleteSystem(SystemListItem system) {
        DefaultMutableTreeNode node = this.findNode(system);
        if (node != null) {
            if (this.isComponentSystem(node)) {
                AggregateSystemPlugin aggregate = (AggregateSystemPlugin)this.systemPluginInNode(node.getParent());
                SystemPlugin<?> selectedComponent = this.systemPluginInNode(node);
                aggregate.getComponents().remove(selectedComponent);
                this.treeModel.removeNodeFromParent(node);
            } else {
                this.treeModel.removeNodeFromParent(node);
            }
        }
    }

    public void moveAggregateComponent(SystemListItem componentListItem, int distanceToMove) {
        DefaultMutableTreeNode componentNode = this.findNode(componentListItem);
        DefaultMutableTreeNode aggregateNode = (DefaultMutableTreeNode)componentNode.getParent();
        SystemPlugin<?> component = this.systemPluginInNode(componentNode);
        AggregateSystemPlugin aggregate = (AggregateSystemPlugin)this.systemPluginInNode(aggregateNode);
        int componentIndexInAggregate = aggregate.getComponents().indexOf(component);
        if (componentIndexInAggregate + distanceToMove < 0 || componentIndexInAggregate + distanceToMove >= aggregate.getComponents().size()) {
            throw new RuntimeException("Move out of range");
        }
        aggregate.getComponents().remove(componentIndexInAggregate);
        aggregate.getComponents().add(componentIndexInAggregate + distanceToMove, component);
        this.treeModel.removeNodeFromParent(componentNode);
        this.treeModel.insertNodeInto(componentNode, aggregateNode, componentIndexInAggregate + distanceToMove);
    }

    public void addComponentToAggregate(SystemListItem aggregateListItem, SystemListItem componentListItem) {
        AggregateSystemPlugin aggregate = (AggregateSystemPlugin)aggregateListItem.getSystemPlugin();
        SystemPlugin component = componentListItem.getSystemPlugin();
        aggregate.addComponent(component);
        DefaultMutableTreeNode aggregateNode = this.findNode(aggregateListItem);
        this.treeModel.insertNodeInto(new DefaultMutableTreeNode(componentListItem), aggregateNode, aggregateNode.getChildCount());
    }

    public void setSelectionListener(SelectionListener selectionListener) {
        this.selectionListener = selectionListener;
    }

    public SystemListItem getSelectedSystem() {
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (selectedNode != null) {
            return (SystemListItem)selectedNode.getUserObject();
        }
        return null;
    }

    public void setContextMenuProvider(ContextMenuProvider contextMenuProvider) {
        this.contextMenuProvider = contextMenuProvider;
    }

    private DefaultMutableTreeNode findNode(SystemListItem system) {
        return this.findNodeForSystemWithId(system.getSystemPlugin().getUI().id());
    }

    private DefaultMutableTreeNode findNodeForSystemWithId(String id) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
        ArrayList<DefaultMutableTreeNode> matchingNodes = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = rootNode.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            SystemListItem s = (SystemListItem)n.getUserObject();
            if (s == null || !s.getSystemPlugin().getUI().id().equals(id)) continue;
            matchingNodes.add(n);
        }
        if (matchingNodes.size() == 0) {
            return null;
        }
        if (matchingNodes.size() == 1) {
            return (DefaultMutableTreeNode)matchingNodes.get(0);
        }
        throw new RuntimeException("More than one node with id");
    }

    private void showContextMenu(MouseEvent e, DefaultMutableTreeNode contextNode) {
        if (this.contextMenuProvider == null) {
            return;
        }
        List<JMenuItem> menuItems = this.contextMenuProvider.contextMenuItems((SystemListItem)contextNode.getUserObject());
        if (!menuItems.isEmpty()) {
            JPopupMenu contextMenu = new JPopupMenu();
            for (JMenuItem i : menuItems) {
                contextMenu.add(i);
            }
            contextMenu.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    public List<JMenuItem> aggregateComponentMoveContextMenuItems(SystemListItem component) {
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        return menuItems;
    }

    public boolean isComponentSystem(SystemListItem system) {
        return this.isComponentSystem(this.findNode(system));
    }

    private boolean isComponentSystem(TreeNode node) {
        return this.isAggregateSystem(node.getParent());
    }

    private boolean isFirstComponentSystem(TreeNode node) {
        return this.isComponentSystem(node) && ((DefaultMutableTreeNode)node).getPreviousSibling() == null;
    }

    private boolean isLastComponentSystem(TreeNode node) {
        return this.isComponentSystem(node) && ((DefaultMutableTreeNode)node).getNextSibling() == null;
    }

    private boolean isAggregateSystem(TreeNode node) {
        return this.systemPluginInNode(node) instanceof AggregateSystemPlugin;
    }

    private SystemPlugin<?> systemPluginInNode(TreeNode node) {
        Object userObject;
        if (node instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)node).getUserObject()) instanceof SystemListItem) {
            return ((SystemListItem)userObject).getSystemPlugin();
        }
        return null;
    }

    class ThisMouseListener
    implements MouseListener {
        ThisMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TreePath contextPath;
            if (SwingUtilities.isRightMouseButton(e) && (contextPath = SystemTree.this.getPathForLocation(e.getX(), e.getY())) != null) {
                SystemTree.this.setSelectionPath(contextPath);
                DefaultMutableTreeNode contextNode = (DefaultMutableTreeNode)contextPath.getLastPathComponent();
                SystemTree.this.showContextMenu(e, contextNode);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    class ThisTreeSelectionListener
    implements TreeSelectionListener {
        ThisTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (SystemTree.this.selectionListener != null) {
                SystemTree.this.selectionListener.selectionChanged(SystemTree.this.getSelectedSystem());
            }
        }
    }

    public static interface ContextMenuProvider {
        public List<JMenuItem> contextMenuItems(SystemListItem var1);
    }

    public static interface SelectionListener {
        public void selectionChanged(SystemListItem var1);
    }
}

