/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.ui.Layer;
import org.jfree.ui.TextAnchor;
import org.seamcat.function.MaskFunctionImpl;
import org.seamcat.presentation.AclrDatasetWrapper;
import org.seamcat.presentation.ChartSaver;
import org.seamcat.presentation.components.DiscreteFunction2TableModelAdapter;
import org.seamcat.presentation.components.DiscreteFunctionGraph;

public class UnwantedEmissionGraph2
extends JPanel
implements DatasetChangeListener {
    private static final Logger LOG = Logger.getLogger(UnwantedEmissionGraph2.class);
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private JFreeChart chart;
    private ChartPanel chartPanel;
    private DiscreteFunction2TableModelAdapter dataset;
    private AclrDatasetWrapper aclrDataset;
    private XYBarRenderer brenderer;
    private IntervalMarker victimMarker;
    private NumberAxis axis2;
    private boolean showACLR = false;
    private boolean aclrEnabled = false;
    private double frequencyOffset;
    private double victimBandwidth;

    public UnwantedEmissionGraph2(DiscreteFunction2TableModelAdapter dataset) {
        super(new GridLayout());
        this.dataset = dataset;
        this.chart = ChartFactory.createXYLineChart(STRINGLIST.getString("EMISSION_GRAPH_TITLE"), STRINGLIST.getString("EMISSION_GRAPH_AXIX_TITLE_X"), STRINGLIST.getString("EMISSION_GRAPH_AXIX_TITLE_Y"), dataset, PlotOrientation.VERTICAL, true, true, false);
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)this.chart.getXYPlot().getRenderer();
        renderer.setSeriesShapesVisible(0, true);
        renderer.setSeriesShapesFilled(0, true);
        this.axis2 = new NumberAxis("Normalized ACLR (dB)");
        XYPlot plot = this.chart.getXYPlot();
        plot.setRangeAxis(1, this.axis2);
        plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
        this.aclrDataset = new AclrDatasetWrapper(dataset);
        plot.setDataset(1, this.aclrDataset);
        plot.mapDatasetToRangeAxis(1, 1);
        this.brenderer = new XYBarRenderer();
        this.brenderer.setDrawBarOutline(true);
        this.brenderer.setSeriesFillPaint(0, new Color(0, 183, 239, 100));
        this.brenderer.setSeriesItemLabelsVisible(0, true);
        this.brenderer.setSeriesItemLabelGenerator(0, this.aclrDataset);
        plot.setRenderer(1, this.brenderer);
        this.victimMarker = new IntervalMarker(-5.0, 5.0, new Color(0, 0, 255, 25), new BasicStroke(0.5f), new Color(0, 0, 255, 25), new BasicStroke(1.0f), 1.0f);
        this.victimMarker.setLabel("Victim System");
        this.victimMarker.setLabelFont(new Font("Dialog", 0, 11));
        this.victimMarker.setLabelTextAnchor(TextAnchor.TOP_CENTER);
        plot.addDomainMarker(this.victimMarker, Layer.FOREGROUND);
        dataset.addChangeListener(this);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setMouseZoomable(true, false);
        this.chartPanel.setPreferredSize(new Dimension(400, 350));
        this.chartPanel.getChart().getXYPlot().getRangeAxis().setAutoRange(true);
        DiscreteFunctionGraph.applyStyles(this.chartPanel, this.getFont(), true);
        this.add(this.chartPanel);
    }

    @Override
    public void datasetChanged(DatasetChangeEvent dce) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Chart received DatasetChangeEvent");
        }
        if (this.showACLR) {
            MaskFunctionImpl f = this.dataset.getDiscreteFunction2();
            this.setAclrEnabled(f.getBounds().getMax() >= 0.0 && f.getBounds().getMin() <= 0.0, false);
            if (this.aclrEnabled) {
                this.aclrDataset.setDiscreteFunction2(f);
            }
        }
        ItemLabelPosition position = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER_RIGHT, TextAnchor.CENTER_RIGHT, 1.5707963267948966);
        this.brenderer.setPositiveItemLabelPositionFallback(position);
        this.brenderer.setNegativeItemLabelPositionFallback(position);
        this.brenderer.setSeriesPositiveItemLabelPosition(0, position);
        this.brenderer.setSeriesNegativeItemLabelPosition(0, position);
        this.chart.getPlot().datasetChanged(dce);
    }

    public MaskFunctionImpl getDiscreteFunction2() {
        return this.dataset.getDiscreteFunction2();
    }

    public void setLabels(String xUnit, String yUnit) {
        this.chart.getXYPlot().getDomainAxis().setLabel(xUnit);
        this.chart.getXYPlot().getRangeAxis().setLabel(yUnit);
    }

    public void setAclrEnabled(boolean enabled, boolean refresh) {
        if (this.aclrEnabled ^ enabled || refresh) {
            this.aclrEnabled = enabled;
            if (enabled) {
                this.chart.getXYPlot().setDataset(1, this.aclrDataset);
                this.chart.getXYPlot().setRangeAxis(1, this.axis2, true);
                this.chart.getXYPlot().mapDatasetToRangeAxis(1, 1);
                if (this.frequencyOffset == -1.0) {
                    this.victimMarker.setStartValue(0.0);
                    this.victimMarker.setEndValue(0.0);
                    this.victimMarker.setAlpha(0.0f);
                } else {
                    double start = this.frequencyOffset - this.victimBandwidth / 2.0;
                    double end = this.frequencyOffset + this.victimBandwidth / 2.0;
                    this.victimMarker.setStartValue(start);
                    this.victimMarker.setEndValue(end);
                    this.victimMarker.setAlpha(1.0f);
                }
            } else {
                this.chart.getXYPlot().setRangeAxis(1, null, true);
                this.chart.getXYPlot().setDataset(1, null);
                this.victimMarker.setStartValue(0.0);
                this.victimMarker.setEndValue(0.0);
                this.victimMarker.setAlpha(0.0f);
            }
        }
    }

    public void setVictimCharacteristics(double victimBandwidth, double frequencyOffset, boolean showACLR) {
        this.showACLR = showACLR;
        this.frequencyOffset = frequencyOffset;
        this.victimBandwidth = victimBandwidth;
        this.setAclrEnabled(showACLR, true);
    }

    public void setInterferingBandwidth(double valueInMHz) {
        this.aclrDataset.setInterfererBandwidth(valueInMHz);
        this.repaint();
    }

    public void setAdjacentChannel(double valueInMHz) {
        this.aclrDataset.setAdjacentChannel(valueInMHz);
        this.repaint();
    }

    public void refreshChart() {
        if (this.chart != null) {
            this.chart.fireChartChanged();
        }
    }

    public void drawGraphToGraphics(Graphics2D g, Rectangle r) {
        this.chart.setBackgroundPaint(null);
        this.chart.draw(g, r);
    }

    public void saveChartImage() {
        ChartSaver.saveChart(this.chartPanel);
    }
}

