/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ValidatorDocument
extends PlainDocument {
    protected static final char[] CHARACTERS = new char[]{' ', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '@'};
    protected static final char[] FLOAT_DELIMITERS = new char[]{'.', ','};
    protected static final char[] INTEGERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    protected static final char[] MATHS = new char[]{'=', '+', '-', '*', '/', '^'};
    protected static final char[] NEGATE = new char[]{'-'};
    protected static final char[] NEWLINE = new char[]{'\n'};
    protected static final char[] PUNCTUATION = new char[]{'.', ',', ';', ':', '!', '\"', '#', '$', '%', '&', '/', '(', ')', '?'};
    private final Type[] allowedTypes;

    private static boolean validateString(String s, char[] allowedChars) {
        if (s.length() > 0) {
            char[] chars = s.toCharArray();
            block0: for (int x = 0; x < chars.length; ++x) {
                for (int y = 0; y < allowedChars.length; ++y) {
                    if (allowedChars[y] == chars[x]) continue block0;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    ValidatorDocument(Type ... allowedTypes) {
        this.allowedTypes = allowedTypes;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.validateString(str)) {
            super.insertString(offs, str, a);
        }
    }

    private boolean validateString(String s) {
        boolean ok = false;
        for (Type type : this.allowedTypes) {
            switch (type) {
                case INTEGERS: {
                    ok = ValidatorDocument.validateString(s, INTEGERS);
                    break;
                }
                case FLOAT_DELIMITERS: {
                    ok = ValidatorDocument.validateString(s, FLOAT_DELIMITERS);
                    break;
                }
                case CHARACTERS: {
                    ok = ValidatorDocument.validateString(s, CHARACTERS);
                    break;
                }
                case NEWLINE: {
                    ok = ValidatorDocument.validateString(s, NEWLINE);
                    break;
                }
                case PUNCTUATION: {
                    ok = ValidatorDocument.validateString(s, PUNCTUATION);
                    break;
                }
                case MATHS: {
                    ok = ValidatorDocument.validateString(s, MATHS);
                    break;
                }
                case NEGATE: {
                    ok = ValidatorDocument.validateString(s, NEGATE);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported validation type encountered: " + (Object)((Object)type));
                }
            }
            if (ok) break;
        }
        return ok;
    }

    public static enum Type {
        CHARACTERS,
        FLOAT_DELIMITERS,
        INTEGERS,
        MATHS,
        NEGATE,
        NEWLINE,
        PUNCTUATION;

    }
}

