/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.display;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.seamcat.help.SeamcatHelpResolver;

public class ControlButtonPanel
extends JPanel {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private final JButton save;

    public ControlButtonPanel(final Component owner, ActionListener saveAction, ActionListener saveImageAc) {
        super(new GridBagLayout());
        JButton close = null;
        if (owner != null) {
            close = new JButton(STRINGLIST.getString("BTN_CAPTION_CLOSE"));
            close.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (owner != null && owner instanceof Window) {
                        ((Window)owner).dispose();
                    }
                }
            });
        }
        this.save = new JButton(STRINGLIST.getString("BTN_CAPTION_SAVE"));
        this.save.addActionListener(saveAction);
        JButton saveImage = new JButton("Save image");
        saveImage.addActionListener(saveImageAc);
        JButton help = new JButton(STRINGLIST.getString("BTN_CAPTION_HELP"));
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeamcatHelpResolver.showHelp(this);
            }
        });
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 50.0, 14, 2, new Insets(0, 0, 0, 0), 1, 1);
        this.add(Box.createVerticalGlue(), gc);
        gc.weighty = 1.0;
        this.add((Component)this.save, gc);
        if (saveImageAc != null) {
            this.add((Component)saveImage, gc);
        }
        if (close != null) {
            this.add((Component)close, gc);
        }
        this.add((Component)help, gc);
    }

    public void enableSave(boolean save) {
        this.save.setEnabled(save);
    }
}

