/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.seamcat.model.functions.Function;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.types.result.FunctionResultType;
import org.seamcat.presentation.ChartSaver;
import org.seamcat.presentation.components.DiscreteFunctionGraph;
import org.seamcat.presentation.components.SaveFileChooser;
import org.seamcat.presentation.display.ControlButtonPanel;
import org.seamcat.presentation.display.UniqueName;
import org.seamcat.presentation.layout.VerticalSubPanelLayoutManager;
import org.seamcat.tabulardataio.FileDataIO;

public class FunctionPanel
extends JPanel {
    private ChartPanel chartPanel;
    private JPanel chartContainer = new JPanel(new BorderLayout());
    private final ControlButtonPanel control;
    private List<FunctionResultType> functions;

    public FunctionPanel() {
        this((Component)null);
    }

    public FunctionPanel(Component owner) {
        super(new BorderLayout());
        this.add((Component)this.chartContainer, "Center");
        JPanel right = new JPanel();
        right.setLayout(new VerticalSubPanelLayoutManager());
        right.setPreferredSize(new Dimension(200, right.getPreferredSize().height));
        ActionListener saveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileDataIO fileIO = SaveFileChooser.chooseFile(FunctionPanel.this.getParent());
                if (fileIO != null) {
                    fileIO.saveValues((FunctionResultType)FunctionPanel.this.functions.get(0));
                }
            }
        };
        this.control = new ControlButtonPanel(owner, saveAction, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartSaver.saveChart(FunctionPanel.this.chartPanel);
            }
        });
        right.add(this.control);
        this.add((Component)right, "East");
    }

    public void setModel(List<FunctionResultType> functions) {
        this.functions = functions;
        this.control.enableSave(functions.size() == 1);
        String title = "Functions";
        if (functions.size() == 1) {
            FunctionResultType type = functions.get(0);
            title = type.def().name();
        }
        String x = "";
        String y = "";
        XYSeriesCollection collection = new XYSeriesCollection();
        UniqueName uniqueName = new UniqueName();
        for (FunctionResultType function : functions) {
            Function value = function.value();
            x = function.def().unit();
            y = function.def().yUnit();
            XYSeries series = new XYSeries((Comparable)((Object)uniqueName.getName(function.def().name())));
            for (Point2D point2D : value.getPoints()) {
                series.add(point2D.getX(), point2D.getY());
            }
            collection.addSeries(series);
        }
        JFreeChart scatterPlot = ChartFactory.createXYLineChart(title, x, y, collection, PlotOrientation.VERTICAL, true, false, false);
        XYPlot p = scatterPlot.getXYPlot();
        scatterPlot.setBackgroundPaint(this.getBackground());
        p.setBackgroundPaint(Color.white);
        this.chartPanel = new ChartPanel(scatterPlot);
        DiscreteFunctionGraph.applyStyles(this.chartPanel, this.getFont(), true);
        this.chartPanel.setPreferredSize(new Dimension(500, 270));
        this.chartContainer.removeAll();
        this.chartContainer.add((Component)this.chartPanel, "Center");
        this.chartContainer.revalidate();
        this.chartContainer.repaint();
    }
}

