/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.display;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.seamcat.presentation.layout.VerticalSubPanelLayoutManager;
import org.seamcat.presentation.propagationtest.VectorHolder;

public class IdentificationPanel
extends JPanel {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private JLabel lbMeanDBm = new JLabel("");
    private JLabel lbMedian = new JLabel("");
    private JLabel lbStddev = new JLabel("");
    private JLabel lbVariance = new JLabel("");
    private JLabel lbMin = new JLabel("");
    private JLabel lbMax = new JLabel("");
    private NumberFormat nf = new DecimalFormat("0.00");

    public IdentificationPanel() {
        this.setLayout(new VerticalSubPanelLayoutManager());
        this.add(this.lbMeanDBm);
        this.add(this.lbMedian);
        this.add(this.lbStddev);
        this.add(this.lbVariance);
        this.add(this.lbMin);
        this.add(this.lbMax);
        this.setBorder(new TitledBorder(STRINGLIST.getString("RESULTS_VECTOR_IDENTIFICATION_TITLE")));
    }

    public String formatDouble(double value) {
        return this.nf.format(value);
    }

    public void setModel(VectorHolder model) {
        if (model == null) {
            this.setNA(this.lbMeanDBm, "RESULTS_VECTOR_MEAN_PREFIX");
            this.setNA(this.lbMedian, "RESULTS_VECTOR_MEDIAN_PREFIX");
            this.setNA(this.lbStddev, "RESULTS_VECTOR_STD_PREFIX");
            this.setNA(this.lbVariance, "RESULTS_VECTOR_VARIANCE_PREFIX");
            this.setNA(this.lbMin, "RESULTS_VECTOR_MIN_PREFIX");
            this.setNA(this.lbMax, "RESULTS_VECTOR_MAX_PREFIX");
        } else {
            String unit;
            String special = unit = model.getUnit() == null ? "" : model.getUnit();
            if ("dBm".equals(unit)) {
                special = "dB";
            }
            this.setText(this.lbMeanDBm, "RESULTS_VECTOR_MEAN_PREFIX", model.getAverage(), unit);
            this.setText(this.lbMedian, "RESULTS_VECTOR_MEDIAN_PREFIX", model.getMedian(), unit);
            this.setText(this.lbStddev, "RESULTS_VECTOR_STD_PREFIX", model.getStandardDeviation(), special);
            this.setText(this.lbVariance, "RESULTS_VECTOR_VARIANCE_PREFIX", model.getVariance(), special);
            this.setText(this.lbMin, "RESULTS_VECTOR_MIN_PREFIX", model.getMin(), unit);
            this.setText(this.lbMax, "RESULTS_VECTOR_MAX_PREFIX", model.getMax(), unit);
        }
    }

    private void setNA(JLabel label, String pre) {
        label.setText(STRINGLIST.getString(pre) + " N/A");
    }

    private void setText(JLabel label, String pre, double number, String unit) {
        label.setText(STRINGLIST.getString(pre) + this.nf.format(number) + " " + unit);
    }
}

