/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.display;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import org.seamcat.model.types.result.BarChartResultType;
import org.seamcat.model.types.result.FunctionResultType;
import org.seamcat.model.types.result.SamplesResultType;
import org.seamcat.model.types.result.ScatterDiagramResultType;
import org.seamcat.model.types.result.VectorResult;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.compare.VectorGroupDialog;
import org.seamcat.presentation.display.BarChartDialog;
import org.seamcat.presentation.display.BarChartGroupDialog;
import org.seamcat.presentation.display.BarChartGroupResultType;
import org.seamcat.presentation.display.FunctionDialog;
import org.seamcat.presentation.display.NamedVectorResult;
import org.seamcat.presentation.display.ScatterDiagramDialog;
import org.seamcat.presentation.display.ScatterGroupDialog;
import org.seamcat.presentation.display.ScatterGroupResultType;
import org.seamcat.presentation.display.SingleValueGroupDialog;
import org.seamcat.presentation.display.SingleValueGroupResultType;
import org.seamcat.presentation.display.VectorDialog;
import org.seamcat.presentation.display.VectorGroupResultType;

public class MouseClickTypeHandler
extends MouseAdapter {
    private JTable table;

    public MouseClickTypeHandler(JTable table) {
        this.table = table;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            if (e.getClickCount() > 1) {
                Object value = this.table.getModel().getValueAt(this.table.getSelectedRow(), 0);
                if (value instanceof VectorResultType) {
                    VectorResultType vector = (VectorResultType)value;
                    double[] values = vector.getValue().asArray();
                    if (values == null || values.length == 0) {
                        return;
                    }
                    new VectorDialog(vector.getValue().asArray(), vector.getName(), vector.getUnit(), vector.getLabel());
                } else if (value instanceof SamplesResultType) {
                    SamplesResultType type = (SamplesResultType)value;
                    VectorGroupResultType group = new VectorGroupResultType(type.getName(), type.getUnit());
                    List<Double>[] samples = type.getSamples();
                    for (int i = 0; i < samples.length; ++i) {
                        List<Double> list = samples[i];
                        group.addVector(new NamedVectorResult("Event " + i, new VectorResult(list)));
                    }
                    new VectorGroupDialog(group, "Samples");
                } else if (value instanceof ScatterGroupResultType) {
                    new ScatterGroupDialog((ScatterGroupResultType)value);
                } else if (value instanceof ScatterDiagramResultType) {
                    new ScatterDiagramDialog((ScatterDiagramResultType)value);
                } else if (value instanceof VectorGroupResultType) {
                    new VectorGroupDialog((VectorGroupResultType)value);
                } else if (value instanceof BarChartResultType) {
                    new BarChartDialog((BarChartResultType)value);
                } else if (value instanceof BarChartGroupResultType) {
                    new BarChartGroupDialog((BarChartGroupResultType)value);
                } else if (value instanceof Exception) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    ((Exception)value).printStackTrace(pw);
                    JOptionPane.showMessageDialog(MainWindow.getInstance(), sw.toString(), "Exception Occurred", 0);
                } else if (value instanceof FunctionResultType) {
                    FunctionResultType f = (FunctionResultType)value;
                    if (f.value().isConstant()) {
                        return;
                    }
                    new FunctionDialog(f);
                } else if (value instanceof SingleValueGroupResultType) {
                    new SingleValueGroupDialog((SingleValueGroupResultType)value);
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }
}

