/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.display;

import java.util.List;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.axis.LogAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.data.Range;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.XYSeriesCollection;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.presentation.display.DensitySeries;
import org.seamcat.presentation.display.UniqueName;
import org.seamcat.presentation.propagationtest.VectorHolder;

public class VectorHelper {
    public static HistogramDataset getDensityHistogram(List<VectorHolder> propagations, int bin) {
        HistogramDataset collection = new HistogramDataset();
        for (VectorHolder propagationHolder : propagations) {
            DensitySeries densitySeries = propagationHolder.getDensityDataSeries();
            if (densitySeries == null || propagationHolder.getData().length <= 0) continue;
            collection.addSeries((Comparable)((Object)densitySeries.comparableKey), propagationHolder.getData(), bin);
        }
        collection.setType(HistogramType.RELATIVE_FREQUENCY);
        return collection;
    }

    public static HistogramDataset getDensityHistogram(List<VectorHolder> propagations) {
        HistogramDataset collection = new HistogramDataset();
        for (VectorHolder propagationHolder : propagations) {
            DensitySeries densitySeries = propagationHolder.getDensityDataSeries();
            if (densitySeries == null || propagationHolder.getData().length <= 0) continue;
            collection.addSeries((Comparable)((Object)densitySeries.comparableKey), propagationHolder.getData(), densitySeries.bin);
        }
        collection.setType(HistogramType.RELATIVE_FREQUENCY);
        return collection;
    }

    private static double[] getMinAndMaxSortedDistribution(List<VectorHolder> propagations) {
        double[] values = new double[2];
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (VectorHolder propagationHolder : propagations) {
            double[] sortedDistributions = propagationHolder.getSortedDistributions();
            min = sortedDistributions[0] < min ? sortedDistributions[0] : min;
            max = sortedDistributions[sortedDistributions.length - 1] > max ? sortedDistributions[sortedDistributions.length - 1] : max;
        }
        values[0] = min;
        values[1] = max;
        return values;
    }

    public static int getLongestDisplayData(List<VectorHolder> propagations) {
        int length = Integer.MIN_VALUE;
        for (VectorHolder propagationHolder : propagations) {
            length = propagationHolder.getData().length > length ? propagationHolder.getData().length : length;
        }
        return length;
    }

    private static double getMinumimLogDomainValue(List<VectorHolder> propagations, double minDataValue) {
        double rangeStart = Double.MAX_VALUE;
        for (VectorHolder propagationHolder : propagations) {
            double[] sortedDistributions = propagationHolder.getSortedDistributions();
            double tmp = Mathematics.getMinimumLogDomainValue(sortedDistributions[0], minDataValue);
            rangeStart = tmp < rangeStart ? tmp : rangeStart;
        }
        return rangeStart;
    }

    private static double[] getMinAndMax(List<VectorHolder> propagations) {
        double max = -2.147483648E9;
        double min = 2.147483647E9;
        double[] minAndMax = new double[2];
        for (VectorHolder propagationHolder : propagations) {
            max = max > propagationHolder.getMaxAxis() ? max : propagationHolder.getMaxAxis();
            min = min < propagationHolder.getMinAxis() ? min : propagationHolder.getMinAxis();
        }
        minAndMax[0] = min;
        minAndMax[1] = max;
        return minAndMax;
    }

    public static XYSeriesCollection getVectorSeriesCollection(List<VectorHolder> propagations) {
        XYSeriesCollection collection = new XYSeriesCollection();
        UniqueName uniqueName = new UniqueName();
        for (VectorHolder propagationHolder : propagations) {
            propagationHolder.setTitle(uniqueName.getName(propagationHolder.getTitle()));
            collection.addSeries(propagationHolder.getVectorDataSeries());
        }
        return collection;
    }

    public static XYSeriesCollection getCumulativeSeriesCollection(List<VectorHolder> propagations) {
        XYSeriesCollection collection = new XYSeriesCollection();
        for (VectorHolder propagationHolder : propagations) {
            collection.addSeries(propagationHolder.getCumulativeDataSeries());
        }
        return collection;
    }

    public static void setVectorDataRange(List<VectorHolder> propagations, boolean signalIsConstant, ChartPanel vectorChart) {
        double[] minAndMax;
        Range xRange;
        NumberAxis x = (NumberAxis)vectorChart.getChart().getXYPlot().getDomainAxis();
        NumberAxis y = (NumberAxis)vectorChart.getChart().getXYPlot().getRangeAxis();
        x.setAutoRange(false);
        if (propagations.get(0).getSortedDistributions() == null) {
            xRange = new Range(0.0, VectorHelper.getLongestDisplayData(propagations));
        } else {
            minAndMax = VectorHelper.getMinAndMaxSortedDistribution(propagations);
            xRange = new Range(minAndMax[0], minAndMax[1]);
        }
        x.setRange(xRange);
        if (VectorHelper.getLongestDisplayData(propagations) == 1) {
            signalIsConstant = true;
        }
        if (!signalIsConstant) {
            y.setAutoRange(false);
            minAndMax = VectorHelper.getMinAndMax(propagations);
            Range yRange = new Range(minAndMax[0], minAndMax[1]);
            if (Math.abs(minAndMax[0] - minAndMax[1]) < 0.001) {
                y.setRange(minAndMax[0] - 0.1, minAndMax[1] + 0.1);
            } else {
                y.setRange(yRange);
            }
        } else {
            y.setAutoRange(true);
        }
    }

    public static void setLogDataRange(List<VectorHolder> propagations, boolean isUniform, double minDataValue, double maxDataValue, ChartPanel vectorLogChart, boolean hasSortedDistributions) {
        LogAxis xLog = (LogAxis)vectorLogChart.getChart().getXYPlot().getDomainAxis();
        xLog.setAutoRange(false);
        if (hasSortedDistributions && isUniform) {
            double rangeStart = VectorHelper.getMinumimLogDomainValue(propagations, minDataValue);
            xLog.setRange(rangeStart, maxDataValue);
        }
        for (VectorHolder propagation : propagations) {
            double[] range = propagation.getDisplayRange();
            xLog.setRange(new Range(range[0], range[1]));
        }
    }

    public static void setPropagationStatistics(VectorHolder propagation) {
        if (propagation == null) {
            return;
        }
        double[] data = propagation.getData();
        if (data == null) {
            return;
        }
        propagation.setMedian(VectorHelper.getMedian(data));
        propagation.setAverage(Mathematics.getAverage(data));
        propagation.setStandardDeviation(Mathematics.getStdDev(data, propagation.getAverage()));
        double[] displayData = propagation.getData();
        double stddev = propagation.getStandardDeviation();
        propagation.setVariance(stddev * stddev);
        propagation.setMin(Mathematics.min(displayData));
        propagation.setMax(Mathematics.max(displayData));
        propagation.setMinAxis(Mathematics.min(displayData) - stddev);
        propagation.setMaxAxis(Mathematics.max(displayData) + stddev);
    }

    private static double getMedian(double[] data) {
        return Mathematics.getMedian(data, data.length, false);
    }
}

