/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.distributiontest;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.Random;
import javax.swing.JFrame;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.distributions.RayleighDistribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.components.NavigateButtonPanel;
import org.seamcat.presentation.display.VectorDialog;
import org.seamcat.presentation.distributiontest.DistributionTestUI;
import org.seamcat.presentation.genericgui.panelbuilder.GenericPanelEditor;

public class DistributionTestDialog
extends EscapeDialog {
    private Random random = new Random();

    public DistributionTestDialog(JFrame owner) {
        super((Frame)owner, "Seamcat Distribution Test");
        final GenericPanelEditor<DistributionTestUI> editor = new GenericPanelEditor<DistributionTestUI>(owner, DistributionTestUI.class, Factory.instance(DistributionTestUI.class));
        editor.getItems().get(3).setRelevant(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(editor, "Center");
        this.getContentPane().add((Component)new NavigateButtonPanel(this, false, "Generate and show samples"){

            @Override
            public void btnOkActionPerformed() {
                DistributionTestUI model = (DistributionTestUI)editor.getModel();
                Distribution distribution = model.distribution();
                if (distribution instanceof RayleighDistribution) {
                    ((RayleighDistribution)distribution).setExperimental(model.experimental());
                }
                double[] samples = new double[model.samples()];
                for (int i = 0; i < samples.length; ++i) {
                    samples[i] = model.testRandom() ? DistributionTestDialog.this.random.nextDouble() : distribution.trial();
                }
                new VectorDialog(DistributionTestDialog.this, samples, model.samples() + " samples from " + (model.testRandom() ? "internal Java random" : distribution.toString()), "");
            }
        }, "South");
        this.pack();
        this.setSize(400, 200);
        this.setLocationRelativeTo(owner);
    }
}

