/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.distributiontest;

import java.util.List;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.distributions.RayleighDistribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.genericgui.item.DistributionItem;
import org.seamcat.presentation.genericgui.panelbuilder.ChangeListener;

public interface DistributionTestUI {
    public static final Distribution distribution = Factory.distributionFactory().getUniformDistribution(0.0, 1.0);
    public static final int samples = 20000;
    public static final boolean experimental = false;
    public static final ChangeListener<DistributionTestUI> change = new ChangeListener<DistributionTestUI>(){

        @Override
        public void handle(DistributionTestUI model, List<AbstractItem> items, AbstractItem changedItem) {
            if (changedItem instanceof DistributionItem) {
                Distribution dist = (Distribution)changedItem.getValue();
                items.get(3).setRelevant(dist instanceof RayleighDistribution);
            }
        }
    };

    @Config(order=1, name="Distribution")
    public Distribution distribution();

    @Config(order=2, name="Test Java random")
    public boolean testRandom();

    @Config(order=3, name="Number of samples")
    public int samples();

    @Config(order=4, name="Use the former Rayleigh distribution (prior to v5.2.0)")
    public boolean experimental();
}

