/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.emissiontest;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.EmissionMask;
import org.seamcat.model.functions.FunctionException;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.display.VectorDialog;
import org.seamcat.presentation.emissiontest.EmissionTestPanel;
import org.seamcat.presentation.genericgui.panelbuilder.GenericPanelEditor;

public class EmissionMaskTestDialog
extends EscapeDialog {
    private static final Logger LOG = Logger.getLogger(EmissionMaskTestDialog.class);
    private static final String TITLE = "Emission Mask Test";

    public EmissionMaskTestDialog(JFrame owner) {
        super((Frame)owner, TITLE);
        this.getContentPane().setLayout(new BorderLayout());
        final GenericPanelEditor<EmissionTestPanel> editor = new GenericPanelEditor<EmissionTestPanel>(owner, EmissionTestPanel.class, Factory.instance(EmissionTestPanel.class));
        JPanel south = new JPanel();
        JButton btn_Gen = new JButton("Generate and show samples");
        south.add(btn_Gen);
        JButton btn_Close = new JButton("Close");
        south.add(btn_Close);
        this.getContentPane().add(editor, "Center");
        this.getContentPane().add((Component)south, "South");
        btn_Gen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmissionTestPanel model = (EmissionTestPanel)editor.getModel();
                int events = model.samples();
                EmissionMask function = model.mask();
                Distribution difference = model.frequencyDiff();
                MaskFunction normalized = function.getEmissionMask().normalize();
                double ref = model.bandwidth() / 1000.0;
                double[] samples = new double[events];
                for (int i = 0; i < samples.length; ++i) {
                    try {
                        samples[i] = normalized.integrate(difference.trial(), ref);
                        continue;
                    }
                    catch (FunctionException ex) {
                        LOG.error("An Error occured", ex);
                    }
                }
                new VectorDialog(EmissionMaskTestDialog.this, samples, events + " samples from specified function", "");
            }
        });
        btn_Close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmissionMaskTestDialog.this.setVisible(false);
            }
        });
        ((JComponent)this.getContentPane()).setBorder(new TitledBorder("Configuration"));
        this.pack();
        this.setLocationRelativeTo(owner);
    }
}

