/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.eventprocessing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import org.seamcat.eventbus.Subscriber;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.events.TextWidgetValueUpdatedEvent;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.plugin.EventProcessingConfiguration;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.WorkspaceView;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.eventprocessing.EventProcessingSelectionPanel;
import org.seamcat.presentation.eventprocessing.PluginConfigurationIdentificationPanel;
import org.seamcat.presentation.eventprocessing.PluginConfigurationPanel;

public class EventProcessingPanel
extends JPanel {
    private final EventProcessingSelectionPanel selectionPanel;
    private JPanel detailPanel;
    private JLabel noSelection = new JLabel("No selected event processing plugins");
    private PluginConfigurationPanel currentEditor;
    private List<EventProcessingConfiguration> model;
    private int index;

    public EventProcessingPanel(WorkspaceView view) {
        super(new BorderLayout());
        this.detailPanel = new JPanel(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(1, true);
        this.model = view.getWorkspace().getEventProcessingList();
        this.selectionPanel = new EventProcessingSelectionPanel(this, view.getWorkspace());
        jSplitPane.add(this.selectionPanel);
        this.detailPanel.add((Component)this.noSelection, "Center");
        jSplitPane.add(new BorderPanel(this.detailPanel, "Configure Selected Plugin"));
        if (!this.model.isEmpty()) {
            this.layoutDetail(0, this.model.get(0));
        }
        this.add(jSplitPane);
        Subscriber.subscribe(this);
    }

    private void layoutDetail(int index, EventProcessingConfiguration configuration) {
        this.index = index;
        this.detailPanel.removeAll();
        this.currentEditor = new PluginConfigurationPanel(MainWindow.getInstance(), configuration, true, EventProcessingConfiguration.class);
        JScrollPane comp = new JScrollPane(this.currentEditor);
        comp.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.detailPanel.add(comp);
        this.detailPanel.revalidate();
        this.detailPanel.repaint();
    }

    public void selected(int index) {
        this.layoutDetail(index, this.model.get(index));
    }

    public void deSelect() {
        this.currentEditor = null;
        this.detailPanel.removeAll();
        this.detailPanel.add((Component)this.noSelection, "Center");
        this.detailPanel.revalidate();
        this.detailPanel.repaint();
    }

    @UIEventHandler
    public void handle(TextWidgetValueUpdatedEvent event) {
        Configuration model;
        if (event.getContext() instanceof PluginConfigurationIdentificationPanel && (model = ((PluginConfigurationIdentificationPanel)event.getContext()).getModel()) instanceof EventProcessingConfiguration) {
            this.selectionPanel.get(this.index).setDescription(new DescriptionImpl(event.getValue(), model.description().description()));
            this.selectionPanel.update();
        }
    }

    public void updateCurrentEditor() {
        if (this.currentEditor != null) {
            EventProcessingConfiguration configuration = (EventProcessingConfiguration)this.currentEditor.getModel();
            this.model.set(this.index, configuration);
            this.selectionPanel.set(this.index, configuration);
        }
    }
}

