/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.eventprocessing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JFrame;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.events.InfoMessageEvent;
import org.seamcat.events.TextWidgetValueUpdatedEvent;
import org.seamcat.model.Library;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.Model;
import org.seamcat.model.plugin.antenna.AntennaGainPlugin;
import org.seamcat.model.plugin.coverageradius.CoverageRadiusPlugin;
import org.seamcat.model.plugin.eventprocessing.EventProcessingPlugin;
import org.seamcat.model.plugin.propagation.PropagationModelPlugin;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.plugin.CoverageRadiusConfiguration;
import org.seamcat.plugin.EventProcessingConfiguration;
import org.seamcat.plugin.PropagationModelConfiguration;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.components.GenericLibraryImportExportResetWidget;
import org.seamcat.presentation.components.GenericSelectionDialog;
import org.seamcat.presentation.eventprocessing.PluginConfigurationPanel;
import org.seamcat.presentation.genericgui.GenericPanel;
import org.seamcat.presentation.genericgui.item.BooleanItem;
import org.seamcat.presentation.genericgui.item.DoubleItem;
import org.seamcat.presentation.genericgui.item.TextItem;
import org.seamcat.presentation.genericgui.panelbuilder.PluginEditorPanel;

public class PluginConfigurationIdentificationPanel
extends GenericPanel {
    private final TextItem title;
    private final TextItem description;
    private final TextItem notes;
    private final BooleanItem variations;
    private final DoubleItem peakGain;
    private GenericLibraryImportExportResetWidget importExportWidget;
    private PluginEditorPanel container;
    private Configuration model;

    public PluginConfigurationIdentificationPanel(final PluginConfigurationPanel context, final JFrame parent, boolean libraryMode, Configuration model, PluginEditorPanel container, final Class<? extends Configuration> clazz) {
        this.model = model;
        this.container = container;
        if (!libraryMode) {
            this.importExportWidget = new GenericLibraryImportExportResetWidget();
            this.importExportWidget.addImportHandler(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    List<Configuration> configurations = Model.getInstance().getLibrary().getPluginConfigurations(clazz);
                    GenericSelectionDialog<Configuration> dialog = new GenericSelectionDialog<Configuration>(parent, Library.name(clazz) + " Library", configurations);
                    if (dialog.display()) {
                        context.setModel(dialog.getSelectedValue());
                        PluginConfigurationIdentificationPanel.this.setModel(dialog.getSelectedValue());
                        EventBusFactory.getEventBus().publish(new TextWidgetValueUpdatedEvent("", PluginConfigurationIdentificationPanel.this));
                    }
                }
            });
            this.importExportWidget.addExportHandler(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Configuration clone = PluginConfigurationIdentificationPanel.this.getModel().copy();
                    if (!Model.getInstance().getLibrary().addPluginConfiguration(clone)) {
                        if (DialogHelper.overrideInLibrary(parent, PluginConfigurationIdentificationPanel.this.getModel().description().name())) {
                            Model.getInstance().getLibrary().replacePluginInstance(clone);
                            EventBusFactory.getEventBus().publish(new InfoMessageEvent(String.format("'%s' overridden in plugin library", PluginConfigurationIdentificationPanel.this.getModel().description().name())));
                        }
                    } else {
                        Model.getInstance().getLibrary().addJarFile(clone);
                        EventBusFactory.getEventBus().publish(new InfoMessageEvent(String.format("'%s' added to plugin library", PluginConfigurationIdentificationPanel.this.getModel().description().name())));
                    }
                }
            });
            this.importExportWidget.addRestoreHandle(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PropagationModel pc;
                    Configuration defaultConf = pc = PluginConfigurationIdentificationPanel.this.getModel();
                    if (pc instanceof PropagationModelConfiguration) {
                        defaultConf = Factory.propagationModelFactory().getByClass(pc.getPluginClass());
                    } else if (pc instanceof CoverageRadiusConfiguration) {
                        defaultConf = Factory.coverageRadii().getByClass(pc.getPluginClass());
                    } else if (pc instanceof EventProcessingConfiguration) {
                        defaultConf = Factory.eventProcessors().getByClass(pc.getPluginClass());
                    } else if (pc instanceof AntennaGainConfiguration) {
                        defaultConf = Factory.antennaGainFactory().getByClass(pc.getPluginClass());
                    }
                    context.setModel(defaultConf);
                    PluginConfigurationIdentificationPanel.this.setModel(defaultConf);
                    EventBusFactory.getEventBus().publish(new TextWidgetValueUpdatedEvent("", PluginConfigurationIdentificationPanel.this));
                }
            });
            this.addItem(this.importExportWidget);
        }
        this.title = new TextItem().label("Name").valueUpdatedEvent(new TextWidgetValueUpdatedEvent("", this));
        this.addItem(this.title);
        this.description = new TextItem().label("Description").readOnly();
        this.addItem(this.description);
        this.description.initialize();
        Description description = model.description();
        this.title.initialize();
        this.notes = new TextItem().label("Notes").linesToDisplay(3);
        this.addItem(this.notes);
        this.notes.initialize();
        this.notes.setValue(model.getNotes());
        this.variations = new BooleanItem().label("Variations");
        this.peakGain = new DoubleItem().label("Antenna Peak Gain").unit("dBi");
        if (model instanceof PropagationModelConfiguration) {
            this.variations.initialize();
            this.addItem(this.variations);
        } else if (model instanceof AntennaGainConfiguration) {
            this.peakGain.initialize();
            this.addItem(this.peakGain);
        }
        this.setModel(model);
        this.initializeWidgets();
        if (description.description() != null) {
            this.description.setValue(description.description());
            this.description.setRelevant(true);
        } else {
            this.description.setValue("");
            this.description.setRelevant(false);
        }
    }

    public void setModel(Configuration model) {
        this.model = model;
        Description description = model.description();
        this.title.setValue(description.name());
        if (description.description() != null) {
            this.description.setValue(description.description());
            this.description.setRelevant(true);
        } else {
            this.description.setValue("");
            this.description.setRelevant(false);
        }
        this.notes.setValue(model.getNotes());
        if (model instanceof PropagationModelConfiguration) {
            this.variations.setValue(((PropagationModelConfiguration)model).isVariationSelected());
        } else if (model instanceof AntennaGainConfiguration) {
            this.peakGain.setValue(((AntennaGainConfiguration)model).peakGain());
        }
    }

    public Configuration getModel() {
        Class pluginClass = this.model.getPluginClass();
        if (PropagationModelPlugin.class.isAssignableFrom(pluginClass)) {
            return Factory.propagationModelFactory().getByClass(pluginClass, this.container.getModel(), this.variations.getValue(), this.title.getValue(), this.notes.getValue());
        }
        if (AntennaGainPlugin.class.isAssignableFrom(pluginClass)) {
            return Factory.antennaGainFactory().getByClass(pluginClass, this.container.getModel(), this.peakGain.getValue(), this.title.getValue(), this.notes.getValue());
        }
        if (CoverageRadiusPlugin.class.isAssignableFrom(pluginClass)) {
            return Factory.coverageRadii().getByClass(pluginClass, this.container.getModel(), this.title.getValue(), this.notes.getValue());
        }
        if (EventProcessingPlugin.class.isAssignableFrom(pluginClass)) {
            return Factory.eventProcessors().getByClass(pluginClass, this.container.getModel(), "", this.title.getValue(), this.notes.getValue());
        }
        throw new RuntimeException("unknown plugin");
    }

    public void setContainer(PluginEditorPanel container) {
        this.container = container;
    }

    @Override
    public void setGlobalRelevance(boolean relevance) {
        super.setGlobalRelevance(relevance);
        if (this.importExportWidget != null) {
            this.importExportWidget.setGlobalRelevance(relevance);
        }
    }
}

