/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.eventprocessing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.seamcat.model.types.Configuration;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.presentation.components.GainPlotDialog;
import org.seamcat.presentation.eventprocessing.PluginConfigurationIdentificationPanel;
import org.seamcat.presentation.genericgui.GenericPanel;
import org.seamcat.presentation.genericgui.item.CalculatedValueItem;
import org.seamcat.presentation.genericgui.panelbuilder.PluginEditorPanel;

public class PluginConfigurationPanel
extends JPanel {
    private final PluginConfigurationIdentificationPanel id;
    private PluginEditorPanel editor;
    private JPanel container = new JPanel(new BorderLayout());
    private JFrame parent;

    public PluginConfigurationPanel(JFrame parent, Configuration configuration, boolean libraryMode, Class<? extends Configuration> clazz) {
        super(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.parent = parent;
        this.editor = new PluginEditorPanel(parent, configuration);
        this.id = new PluginConfigurationIdentificationPanel(this, parent, libraryMode, configuration, this.editor, clazz);
        this.container.add((Component)this.editor, "Center");
        this.add((Component)this.id, "North");
        if (configuration instanceof AntennaGainConfiguration) {
            panel.add((Component)this.container, "North");
            GenericPanel gainPanel = new GenericPanel();
            CalculatedValueItem item = new CalculatedValueItem().label("Show gain plot");
            gainPanel.addItem(item);
            gainPanel.initializeWidgets();
            item.getEvaluateButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GainPlotDialog dialog = new GainPlotDialog((AntennaGainConfiguration)PluginConfigurationPanel.this.id.getModel());
                    dialog.display();
                }
            });
            panel.add((Component)gainPanel, "Center");
            this.add((Component)panel, "Center");
        } else {
            this.add((Component)this.container, "Center");
        }
    }

    public void setModel(Configuration configuration) {
        this.editor = new PluginEditorPanel(this.parent, configuration);
        this.id.setContainer(this.editor);
        this.id.setModel(configuration);
        this.container.removeAll();
        this.container.add((Component)this.editor, "Center");
        this.container.revalidate();
        this.container.repaint();
    }

    public Configuration getModel() {
        return this.id.getModel();
    }

    public PluginConfigurationIdentificationPanel getIdPanel() {
        return this.id;
    }

    public void setGlobalRelevance(boolean globalRelevance) {
        this.id.setGlobalRelevance(globalRelevance);
        this.editor.setGlobalRelevance(globalRelevance);
    }
}

