/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.eventprocessing;

import java.awt.Component;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.seamcat.model.factory.Cache;
import org.seamcat.model.plugin.CalculatedValue;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.UIPosition;
import org.seamcat.model.plugin.UITab;
import org.seamcat.model.plugin.system.SystemModel;
import org.seamcat.model.types.Configuration;

public class ReadOnlyPanel {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);

    public static void addReadOnly(JPanel panel, Configuration configuration) {
        panel.add((Component)new JLabel("Plugin name"), "label");
        panel.add((Component)new JLabel(configuration.description().name()), "field");
        for (Method method : configuration.getModelClass().getDeclaredMethods()) {
            Config annotation = method.getAnnotation(Config.class);
            if (annotation == null) continue;
            panel.add((Component)new JLabel(annotation.name()), "label");
            try {
                Object invoke = method.invoke(configuration.getModel(), new Object[0]);
                panel.add((Component)new JLabel(invoke == null ? "" : invoke.toString()), "field");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void readOnly(JPanel panel, Class<?> panelClass, Object instance) {
        for (Method method : Cache.orderedConfig(panelClass)) {
            if (method.getReturnType() == CalculatedValue.class) continue;
            Config annotation = method.getAnnotation(Config.class);
            if (STRINGLIST.containsKey(annotation.name())) {
                panel.add((Component)new JLabel(STRINGLIST.getString(annotation.name())), "label");
            } else {
                panel.add((Component)new JLabel(annotation.name()), "label");
            }
            try {
                Object invoke = method.invoke(instance, new Object[0]);
                if (invoke instanceof List) {
                    StringBuilder sb = new StringBuilder("<html>");
                    for (Object element : (List)invoke) {
                        sb.append(element).append("<br>");
                    }
                    sb.append("</html>");
                    panel.add((Component)new JLabel(sb.toString()), "field");
                    continue;
                }
                if (invoke instanceof Map) continue;
                String value = "<html><i>empty</i></html>";
                if (invoke != null && !invoke.toString().isEmpty()) {
                    value = invoke.toString();
                }
                panel.add((Component)new JLabel(value), "field");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void compositeReadOnly(JPanel panel, Class<?> clazz, Object composite) {
        boolean system = SystemModel.class.isAssignableFrom(clazz);
        try {
            for (Method method : Cache.ordered(clazz)) {
                UITab tab;
                if (system && (method.getName().equals("description") || method.getName().equals("general"))) continue;
                UIPosition position = method.getAnnotation(UIPosition.class);
                if (position != null) {
                    panel.add((Component)new JLabel("<html><b>" + position.name() + "</b></html>"), "label");
                    panel.add((Component)new JLabel(""), "field");
                    Object invoke = method.invoke(composite, new Object[0]);
                    if (invoke instanceof Configuration) {
                        ReadOnlyPanel.addReadOnly(panel, (Configuration)invoke);
                    } else {
                        ReadOnlyPanel.readOnly(panel, method.getReturnType(), invoke);
                    }
                }
                if ((tab = method.getAnnotation(UITab.class)) == null) continue;
                panel.add((Component)new JLabel("<html><b>" + tab.value() + "</b></html>"), "label");
                panel.add((Component)new JLabel(""), "field");
                ReadOnlyPanel.compositeReadOnly(panel, method.getReturnType(), method.invoke(composite, new Object[0]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

