/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import org.seamcat.presentation.genericgui.ItemLayoutStrategy;
import org.seamcat.presentation.genericgui.WidgetAndKind;
import org.seamcat.presentation.genericgui.WidgetKind;
import org.seamcat.presentation.genericgui.item.BooleanItem;
import org.seamcat.presentation.genericgui.item.Item;
import org.seamcat.presentation.genericgui.util.Assert;

public class DefaultItemLayoutStrategy
implements ItemLayoutStrategy {
    private static final int WIDGET_HORIZONTAL_SPACING = 3;

    @Override
    public void layoutItemsInContainer(Container container, List<Item> items) {
        int row = 0;
        for (Item item : items) {
            this.layoutItem(container, item, row);
            ++row;
        }
        this.addBottomSpacer(container, row);
    }

    @Override
    public LayoutManager getLayoutManager() {
        return new GridBagLayout();
    }

    private void layoutItem(Container container, Item item, int row) {
        if (item instanceof BooleanItem && item.getWidgets().size() > 1) {
            this.layoutItemWithDefaultLayout(container, item, row);
        } else if (item instanceof BooleanItem || this.countWidgetsOfKinds(item, WidgetKind.NONE) > 0) {
            this.layoutItemWithFullWidthLayout(container, item, row);
        } else if (this.countWidgetsOfKinds(item, WidgetKind.VALUE_PREVIEW) == 0) {
            this.layoutItemWithWideLabelLayout(container, item, row);
        } else {
            this.layoutItemWithDefaultLayout(container, item, row);
        }
    }

    private void layoutItemWithFullWidthLayout(Container container, Item<?> item, int row) {
        Assert.isTrue("Full width layout only supported for items with exactly one widget", item.getWidgets().size() == 1);
        Component valueWidget = item.getWidgets().get(0).getWidget();
        Object constraints = this.makeConstraintsForFullWidthLayout(row);
        container.add(valueWidget, constraints);
    }

    private Object makeConstraintsForFullWidthLayout(int row) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = row;
        constraints.gridwidth = LayoutColumn.values().length;
        constraints.anchor = 512;
        return constraints;
    }

    private void layoutItemWithDefaultLayout(Container container, Item<?> item, int row) {
        this.initializeWidgetsInColumnRange(container, item, row, LayoutColumn.LABEL, LayoutColumn.LABEL, WidgetKind.LABEL);
        this.initializeWidgetsInColumnRange(container, item, row, LayoutColumn.VALUE_PREVIEW, LayoutColumn.VALUE_PREVIEW, WidgetKind.VALUE_PREVIEW);
        this.initializeWidgetsInColumnRange(container, item, row, LayoutColumn.VALUE, LayoutColumn.VALUE, WidgetKind.VALUE);
        this.initializeWidgetsInColumnRange(container, item, row, LayoutColumn.UNIT, LayoutColumn.UNIT, WidgetKind.UNIT);
    }

    private void layoutItemWithWideLabelLayout(Container container, Item item, int row) {
        this.initializeWidgetsInColumnRange(container, item, row, LayoutColumn.LABEL, LayoutColumn.VALUE_PREVIEW, WidgetKind.LABEL);
        this.initializeWidgetsInColumnRange(container, item, row, LayoutColumn.VALUE, LayoutColumn.VALUE, WidgetKind.VALUE);
        this.initializeWidgetsInColumnRange(container, item, row, LayoutColumn.UNIT, LayoutColumn.UNIT, WidgetKind.UNIT);
    }

    private void initializeWidgetsInColumnRange(Container container, Item<?> item, int row, LayoutColumn layoutColumnStart, LayoutColumn layoutColumnEnd, WidgetKind ... kinds) {
        List<WidgetAndKind> widgetsAndKindsForColumn = this.findWidgetsOfKinds(item, kinds);
        if (widgetsAndKindsForColumn.size() == 1) {
            container.add(widgetsAndKindsForColumn.get(0).getWidget(), this.makeColumnRangeConstraints(layoutColumnStart, layoutColumnEnd, row));
        } else if (widgetsAndKindsForColumn.size() > 1) {
            Box box = Box.createHorizontalBox();
            for (WidgetAndKind wak : widgetsAndKindsForColumn) {
                if (box.getComponents().length > 0) {
                    box.add(Box.createHorizontalStrut(5));
                }
                box.add(wak.getWidget());
            }
            container.add((Component)box, this.makeColumnRangeConstraints(layoutColumnStart, layoutColumnEnd, row));
        }
    }

    private Object makeColumnRangeConstraints(LayoutColumn layoutColumnStart, LayoutColumn layoutColumnEnd, int row) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = layoutColumnStart.ordinal();
        constraints.gridwidth = layoutColumnEnd.ordinal() - layoutColumnStart.ordinal() + 1;
        constraints.gridy = row;
        constraints.anchor = 512;
        if (layoutColumnEnd != LayoutColumn.LAST_COLUMN) {
            constraints.insets = new Insets(0, 0, 0, 3);
        }
        if (layoutColumnStart == LayoutColumn.VALUE) {
            constraints.weightx = 1.0;
            constraints.fill = 2;
        }
        return constraints;
    }

    private void addBottomSpacer(Container container, int row) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = row;
        constraints.weighty = 1.0;
        container.add(Box.createVerticalGlue(), constraints);
    }

    private List<WidgetAndKind> findWidgetsOfKinds(Item<?> item, WidgetKind ... kinds) {
        ArrayList<WidgetAndKind> result = new ArrayList<WidgetAndKind>();
        for (WidgetAndKind wak : item.getWidgets()) {
            if (!DefaultItemLayoutStrategy.elementInArray(wak.getKind(), kinds)) continue;
            result.add(wak);
        }
        return result;
    }

    private static <T> boolean elementInArray(T element, T[] array) {
        for (T t : array) {
            if (!t.equals(element)) continue;
            return true;
        }
        return false;
    }

    private int countWidgetsOfKinds(Item item, WidgetKind ... kinds) {
        return this.findWidgetsOfKinds(item, kinds).size();
    }

    private static enum LayoutColumn {
        LABEL,
        VALUE_PREVIEW,
        VALUE,
        UNIT;

        static LayoutColumn LAST_COLUMN;

        static {
            LAST_COLUMN = LayoutColumn.values()[LayoutColumn.values().length - 1];
        }
    }
}

