/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.item;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.seamcat.presentation.SeamcatIcons;
import org.seamcat.presentation.genericgui.WidgetAndKind;
import org.seamcat.presentation.genericgui.WidgetKind;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.genericgui.util.Assert;

public class BooleanItem
extends AbstractItem<Boolean, Object> {
    private JCheckBox valueWidget;

    public JCheckBox getValueWidget() {
        return this.valueWidget;
    }

    @Override
    public BooleanItem label(String label) {
        super.label(label);
        return this;
    }

    @Override
    public List<WidgetAndKind> createWidgets() {
        ArrayList<WidgetAndKind> widgets = new ArrayList<WidgetAndKind>();
        this.valueWidget = new JCheckBox(this.getLabel());
        if (this.getToolTipText() != null) {
            this.valueWidget.setToolTipText(this.getToolTipText());
        }
        this.valueWidget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BooleanItem.this.fireItemChanged();
            }
        });
        widgets.add(new WidgetAndKind(this.valueWidget, WidgetKind.LABEL));
        if (this.getInformation() != null) {
            JLabel info = new JLabel(SeamcatIcons.getImageIcon("SEAMCAT_ICON_INFORMATION", 0));
            info.setToolTipText(this.getInformation());
            widgets.add(new WidgetAndKind(info, WidgetKind.LABEL));
        }
        return widgets;
    }

    @Override
    public Boolean getValue() {
        return this.valueWidget.isSelected();
    }

    @Override
    public void setRelevant(boolean relevant) {
        super.setRelevant(relevant);
    }

    @Override
    public void setValue(Boolean value) {
        Assert.notNull("Item value is null", value);
        this.valueWidget.setSelected(value);
    }

    @Override
    public void updateLabel(String label) {
        super.updateLabel(label);
        this.valueWidget.setText(label);
    }
}

