/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.item;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import org.seamcat.model.distributions.AbstractDistribution;
import org.seamcat.presentation.DistributionDialog;
import org.seamcat.presentation.genericgui.WidgetAndKind;
import org.seamcat.presentation.genericgui.WidgetKind;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.genericgui.item.ItemChanged;
import org.seamcat.presentation.valuepreview.ButtonWithValuePreviewTip;
import org.seamcat.presentation.valuepreview.LabelWithValuePreviewTip;
import org.seamcat.presentation.valuepreview.ValuePreviewTextUtil;
import org.seamcat.presentation.valuepreview.ValuePreviewableDistributionAdapter;

public class DistributionItem
extends AbstractItem<AbstractDistribution, Object> {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private String distributionDialogTitle = "Distribution";
    private AbstractDistribution distribution;
    private JFrame parent;
    private String[] enabledDistributions;
    private LabelWithValuePreviewTip valuePreviewLabel;
    private ButtonWithValuePreviewTip distributionButton;
    private ItemChanged<AbstractDistribution> handler;

    public DistributionItem(JFrame owner, String[] enabledDistributions) {
        this.parent = owner;
        this.enabledDistributions = enabledDistributions;
    }

    @Override
    public DistributionItem label(String label) {
        super.label(label);
        return this;
    }

    @Override
    public DistributionItem unit(String unit) {
        super.unit(unit);
        return this;
    }

    @Override
    public AbstractDistribution getValue() {
        return this.distribution;
    }

    @Override
    public void setValue(AbstractDistribution value) {
        this.distribution = value;
        this.updateValuePreview(this.distribution);
    }

    @Override
    public List<WidgetAndKind> createWidgets() {
        List<WidgetAndKind> widgets = super.createWidgets();
        this.distributionButton = new ButtonWithValuePreviewTip(STRINGLIST.getString("BTN_CAPTION_DISTRIBUTION"));
        this.distributionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DistributionItem.this.showDistributionDialog();
            }
        });
        widgets.add(new WidgetAndKind(this.distributionButton, WidgetKind.VALUE));
        this.valuePreviewLabel = new LabelWithValuePreviewTip();
        widgets.add(new WidgetAndKind(this.valuePreviewLabel, WidgetKind.VALUE_PREVIEW));
        return widgets;
    }

    private void showDistributionDialog() {
        DistributionDialog dialog = new DistributionDialog((Frame)this.parent, true, this.enabledDistributions);
        if (this.distribution == null) {
            if (dialog.showDistributionDialog(this.distributionDialogTitle)) {
                this.distribution = dialog.getDistribution();
                this.updateValuePreview(this.distribution);
                this.fireItemChanged();
                if (this.handler != null) {
                    this.handler.itemChanged(this.distribution);
                }
            }
        } else if (dialog.showDistributionDialog(this.distribution, this.distributionDialogTitle)) {
            this.distribution = dialog.getDistribution();
            this.updateValuePreview(this.distribution);
            this.fireItemChanged();
            if (this.handler != null) {
                this.handler.itemChanged(this.distribution);
            }
        }
    }

    private void updateValuePreview(AbstractDistribution distribution) {
        this.valuePreviewLabel.setText(ValuePreviewTextUtil.previewLabelText(distribution.toString()));
        ValuePreviewableDistributionAdapter previewable = new ValuePreviewableDistributionAdapter(distribution);
        this.valuePreviewLabel.setPreviewable(previewable);
        this.distributionButton.setPreviewable(previewable);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public void addItemChangedHandler(ItemChanged<AbstractDistribution> handler) {
        this.handler = handler;
    }

    public void setDistributionEnabled(String[] distributionEnabled) {
        this.enabledDistributions = distributionEnabled;
    }
}

