/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.item;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.function.FunctionType;
import org.seamcat.model.functions.Function;
import org.seamcat.presentation.DialogFunctionDefine;
import org.seamcat.presentation.genericgui.WidgetAndKind;
import org.seamcat.presentation.genericgui.WidgetKind;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.valuepreview.ButtonWithValuePreviewTip;
import org.seamcat.presentation.valuepreview.LabelWithValuePreviewTip;
import org.seamcat.presentation.valuepreview.ValuePreviewTextUtil;
import org.seamcat.presentation.valuepreview.ValuePreviewableFunctionAdapter;

public class FunctionItem
extends AbstractItem<Function, Object> {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private FunctionType functionType = FunctionType.none();
    private Function function;
    private JFrame parent;
    private String xAxisName;
    private String yAxisName;
    private LabelWithValuePreviewTip valuePreviewLabel;
    private ButtonWithValuePreviewTip functionButton;
    private JLabel unitPreviewLabel;
    private ActionListener actionListener;

    public FunctionItem(JFrame parent, String xAxisName, String yAxisName) {
        this.parent = parent;
        this.xAxisName = xAxisName;
        this.yAxisName = yAxisName;
    }

    public FunctionItem functionType(FunctionType functionType) {
        this.functionType = functionType;
        return this;
    }

    @Override
    public FunctionItem label(String label) {
        super.label(label);
        return this;
    }

    @Override
    public FunctionItem unit(String unit) {
        super.unit(unit);
        this.yAxisName = unit;
        return this;
    }

    @Override
    public Function getValue() {
        return this.function;
    }

    @Override
    public void setValue(Function value) {
        this.function = value;
        this.updateValuePreview(this.function);
        if (!this.functionType.isNone()) {
            this.functionButton.setText("Pattern");
        }
    }

    public void setUnit(String unit) {
        this.updateUnit(unit);
    }

    @Override
    public List<WidgetAndKind> createWidgets() {
        List<WidgetAndKind> widgets = super.createWidgets();
        this.functionButton = new ButtonWithValuePreviewTip(STRINGLIST.getString("BTN_CAPTION_FUNCTION"));
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionItem.this.showFunctionDialog();
            }
        };
        this.functionButton.addActionListener(this.actionListener);
        widgets.add(new WidgetAndKind(this.functionButton, WidgetKind.VALUE));
        this.valuePreviewLabel = new LabelWithValuePreviewTip();
        widgets.add(new WidgetAndKind(this.valuePreviewLabel, WidgetKind.VALUE_PREVIEW));
        this.unitPreviewLabel = new JLabel();
        widgets.add(new WidgetAndKind(this.unitPreviewLabel, WidgetKind.UNIT));
        return widgets;
    }

    private void showFunctionDialog() {
        DialogFunctionDefine dialog = new DialogFunctionDefine(this.parent, this.function, this.functionType, this.xAxisName, this.yAxisName);
        if (dialog.show(this.function, this.getLabel())) {
            this.function = dialog.getFunction();
            this.updateValuePreview(this.function);
            this.fireItemChanged();
        }
        dialog.destroy();
    }

    private void updateValuePreview(Function function) {
        ValuePreviewableFunctionAdapter previewable = new ValuePreviewableFunctionAdapter(function).axisNames(this.xAxisName, this.yAxisName);
        if (this.functionType.isNone()) {
            this.valuePreviewLabel.setText(ValuePreviewTextUtil.previewLabelText(DiscreteFunction.pretty(function)));
            this.valuePreviewLabel.setPreviewable(previewable);
        } else {
            this.valuePreviewLabel.setText("");
        }
        this.functionButton.setPreviewable(previewable);
    }

    private void updateUnit(String string) {
        this.unitPreviewLabel.setText(string);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.functionButton.removeActionListener(this.actionListener);
        this.valuePreviewLabel.dispose();
        this.functionButton.dispose();
    }
}

