/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.item;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.events.InfoMessageEvent;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.function.LibraryFunctionItemImpl;
import org.seamcat.model.Library;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.Model;
import org.seamcat.model.functions.BitRateMapping;
import org.seamcat.model.functions.BlockingMask;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.IntermodulationRejectionMask;
import org.seamcat.model.functions.LibraryFunctionItem;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.DialogLibraryFunctionDefine;
import org.seamcat.presentation.ImportLibraryFunctionDetailPanel;
import org.seamcat.presentation.components.GenericListDetailDialog;
import org.seamcat.presentation.genericgui.WidgetAndKind;
import org.seamcat.presentation.genericgui.WidgetKind;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.resources.ImageLoader;
import org.seamcat.presentation.valuepreview.ButtonWithValuePreviewTip;
import org.seamcat.presentation.valuepreview.LabelWithValuePreviewTip;
import org.seamcat.presentation.valuepreview.ValuePreviewTextUtil;
import org.seamcat.presentation.valuepreview.ValuePreviewableFunctionAdapter;

public class FunctionLibraryItem
extends AbstractItem<LibraryFunctionItem, Object> {
    private String functionDialogTitle;
    private LibraryFunctionItem item;
    private Class<? extends LibraryFunctionItem> libraryClass;
    private JFrame parentDialog;
    private String xAxisName;
    private String yAxisName;
    private LabelWithValuePreviewTip valuePreviewLabel;
    private ButtonWithValuePreviewTip functionButton;
    private JButton importButton;
    private JButton exportButton;
    private JLabel unitLabel = new JLabel();
    ImageIcon importIcon = new ImageIcon(ImageLoader.class.getResource("import_16x16.png"));
    ImageIcon exportIcon = new ImageIcon(ImageLoader.class.getResource("export_16x16.png"));
    private JPanel buttons;

    public FunctionLibraryItem(Class<? extends LibraryFunctionItem> libraryClass, JFrame parent) {
        this.libraryClass = libraryClass;
        this.parentDialog = parent;
        if (libraryClass == IntermodulationRejectionMask.class) {
            this.functionDialogTitle = "Intermodulation Rejection Mask";
            this.xAxisName = "MHz";
            this.yAxisName = "dB";
        } else if (libraryClass == BitRateMapping.class) {
            this.functionDialogTitle = "Bitrate mapping (Link Level Performance)";
            this.xAxisName = "SINR (dB)";
            this.yAxisName = "BitRate (bps/Hz)";
        } else if (libraryClass == BlockingMask.class) {
            this.functionDialogTitle = "Receiver Blocking Mask/ACS";
            this.xAxisName = "MHz";
            this.yAxisName = "dB";
        }
    }

    @Override
    public FunctionLibraryItem label(String label) {
        super.label(label);
        return this;
    }

    @Override
    public FunctionLibraryItem unit(String unit) {
        super.unit(unit);
        return this;
    }

    public FunctionLibraryItem functionDialogTitle(String dialogTitle) {
        this.functionDialogTitle = dialogTitle;
        return this;
    }

    public FunctionLibraryItem setUnit(String unit) {
        this.unitLabel.setText(unit);
        return this;
    }

    public FunctionLibraryItem axisNames(String xAxisName, String yAxisName) {
        this.xAxisName = xAxisName;
        this.yAxisName = yAxisName;
        return this;
    }

    @Override
    public LibraryFunctionItem getValue() {
        return this.item;
    }

    @Override
    public void setValue(LibraryFunctionItem item) {
        this.item = item;
        this.updateValuePreview(item.getFunction());
    }

    @Override
    public List<WidgetAndKind> createWidgets() {
        List<WidgetAndKind> widgets = super.createWidgets();
        this.functionButton = new ButtonWithValuePreviewTip("Edit");
        this.functionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionLibraryItem.this.showFunctionDialog();
            }
        });
        this.importButton = new JButton(this.importIcon);
        this.importButton.setToolTipText("Import");
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibraryItem.this.importPressed();
            }
        });
        this.exportButton = new JButton(this.exportIcon);
        this.exportButton.setToolTipText("Export");
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibraryItem.this.exportPressed();
            }
        });
        this.buttons = new JPanel(new GridLayout(1, 3));
        this.buttons.add(this.functionButton);
        this.buttons.add(this.importButton);
        this.buttons.add(this.exportButton);
        widgets.add(new WidgetAndKind(this.buttons, WidgetKind.VALUE));
        widgets.add(new WidgetAndKind(this.unitLabel, WidgetKind.UNIT));
        this.valuePreviewLabel = new LabelWithValuePreviewTip();
        widgets.add(new WidgetAndKind(this.valuePreviewLabel, WidgetKind.VALUE_PREVIEW));
        return widgets;
    }

    private void showFunctionDialog() {
        DialogLibraryFunctionDefine dialog = new DialogLibraryFunctionDefine(this.parentDialog, true, this.xAxisName, this.yAxisName);
        if (dialog.show(this.item.getFunction(), this.item.description(), this.functionDialogTitle)) {
            this.setValue(new LibraryFunctionItemImpl(dialog.getFunction(), dialog.getDescription()));
            this.updateValuePreview(this.item.getFunction());
            this.fireItemChanged();
        }
    }

    @Override
    public void setRelevant(boolean relevant) {
        super.setRelevant(relevant);
        for (int i = 0; i < this.buttons.getComponentCount(); ++i) {
            this.buttons.getComponent(i).setEnabled(relevant);
        }
    }

    private void updateValuePreview(Function function) {
        this.valuePreviewLabel.setText(ValuePreviewTextUtil.previewLabelText(DiscreteFunction.pretty(function)));
        ValuePreviewableFunctionAdapter previewable = new ValuePreviewableFunctionAdapter(function).axisNames(this.xAxisName, this.yAxisName);
        this.valuePreviewLabel.setPreviewable(previewable);
        this.functionButton.setPreviewable(previewable);
    }

    private void importPressed() {
        List<? extends LibraryFunctionItem> items = Model.getInstance().getLibrary().getLibraryFunction(this.libraryClass);
        GenericListDetailDialog<LibraryFunctionItem> dialog = new GenericListDetailDialog<LibraryFunctionItem>(this.parentDialog, "Import " + this.functionDialogTitle, items){

            @Override
            public void selectedElement(LibraryFunctionItem fun) {
                this.setDetail(new ImportLibraryFunctionDetailPanel(fun, FunctionLibraryItem.this.xAxisName, FunctionLibraryItem.this.yAxisName));
            }
        };
        if (dialog.display()) {
            LibraryFunctionItem selectedValue = (LibraryFunctionItem)dialog.getSelectedValue();
            this.setValue(Factory.functionFactory().fromClass(this.libraryClass, selectedValue.getFunction(), selectedValue.description()));
        }
    }

    private void exportPressed() {
        LibraryFunctionItem value = this.getValue();
        LibraryFunctionItem clone = Factory.functionFactory().fromClass(this.libraryClass, value.getFunction(), value.description());
        if (clone == null) {
            return;
        }
        Library lib = Model.getInstance().getLibrary();
        if (lib.hasLibraryFunction(clone)) {
            if (DialogHelper.overrideInLibrary(this.parentDialog, clone.description().name())) {
                lib.overrideLibraryFunction(clone);
                EventBusFactory.getEventBus().publish(new InfoMessageEvent(String.format("'%s' overridden in function library", clone.description().name())));
                Model.getInstance().persist();
            }
        } else {
            lib.addLibraryFunction(clone);
            EventBusFactory.getEventBus().publish(new InfoMessageEvent(String.format("'%s' added to function library", clone.description().name())));
            Model.getInstance().persist();
        }
    }
}

