/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.item;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import org.seamcat.calculator.CalculatorInputField;
import org.seamcat.presentation.genericgui.WidgetAndKind;
import org.seamcat.presentation.genericgui.WidgetKind;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.genericgui.util.Assert;

public class IntegerItem
extends AbstractItem<Integer, Object> {
    private CalculatorInputField valueWidget;

    @Override
    public IntegerItem label(String label) {
        super.label(label);
        return this;
    }

    @Override
    public List<WidgetAndKind> createWidgets() {
        List<WidgetAndKind> widgets = super.createWidgets();
        this.valueWidget = new CalculatorInputField();
        this.valueWidget.setIntegerMode(true);
        this.valueWidget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntegerItem.this.fireItemChanged();
            }
        });
        widgets.add(new WidgetAndKind(this.valueWidget, WidgetKind.VALUE));
        return widgets;
    }

    @Override
    public Integer getValue() {
        return this.valueWidget.getValueAsInteger();
    }

    @Override
    public void setValue(Integer value) {
        Assert.notNull("Value is null", value);
        this.valueWidget.setValue(value);
    }

    @Override
    public IntegerItem unit(String unit) {
        super.unit(unit);
        return this;
    }
}

