/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.item;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.seamcat.cdma.CDMALinkLevelData;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.events.InfoMessageEvent;
import org.seamcat.model.factory.Model;
import org.seamcat.model.types.CDMALLD;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.components.GenericListDetailDialog;
import org.seamcat.presentation.genericgui.WidgetAndKind;
import org.seamcat.presentation.genericgui.WidgetKind;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.resources.ImageLoader;
import org.seamcat.presentation.systems.cdma.CDMAEditModel;
import org.seamcat.presentation.systems.cdma.CDMALinkLevelDataEditorDialog;
import org.seamcat.presentation.systems.cdma.LLDGraphPanel;

public class LLDItem
extends AbstractItem<CDMALLD, Object> {
    private final JPanel buttons;
    private ImageIcon importIcon = new ImageIcon(ImageLoader.class.getResource("import_16x16.png"));
    private ImageIcon exportIcon = new ImageIcon(ImageLoader.class.getResource("export_16x16.png"));
    private CDMALinkLevelDataEditorDialog lldEditor = new CDMALinkLevelDataEditorDialog();
    private JLabel workspaceLinkData;
    private CDMALinkLevelData model;

    public LLDItem(final JFrame owner, final boolean downlink) {
        this.buttons = new JPanel(new GridLayout(1, 3));
        JButton edit = new JButton("Edit");
        this.buttons.add(edit);
        edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LLDItem.this.editLinkLevelDataButtonActionPerformed(e);
            }
        });
        JButton anImport = new JButton(this.importIcon);
        anImport.setToolTipText("Import");
        this.buttons.add(anImport);
        anImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List<CDMALLD> all = Model.getInstance().getLibrary().getCDMALinkLevelData();
                ArrayList<CDMALinkLevelData> filtered = new ArrayList<CDMALinkLevelData>();
                for (CDMALLD link : all) {
                    if (link.systemType().equals("downlink") && downlink) {
                        filtered.add(new CDMALinkLevelData(link));
                    }
                    if (!link.systemType().equals("uplink") || downlink) continue;
                    filtered.add(new CDMALinkLevelData(link));
                }
                GenericListDetailDialog<CDMALinkLevelData> dialog = new GenericListDetailDialog<CDMALinkLevelData>(owner, "Import CDMA LLD", filtered){

                    @Override
                    public void selectedElement(CDMALinkLevelData data) {
                        LLDGraphPanel panel = new LLDGraphPanel();
                        panel.setGraph((CDMAEditModel)data.getTableModel(1));
                        if (data.getLinkType() == CDMALinkLevelData.LinkType.DOWNLINK) {
                            panel.setRangeLabel(data.getTargetERpct(), data.getTargetERType().toString());
                        }
                        this.setDetail(new BorderPanel(panel, "Preview"));
                    }
                };
                if (dialog.display()) {
                    LLDItem.this.model = (CDMALinkLevelData)dialog.getSelectedValue();
                    LLDItem.this.updateSelectedLinkDataValuePreview();
                }
            }
        });
        JButton export = new JButton(this.exportIcon);
        export.setToolTipText("Export");
        this.buttons.add(export);
        export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CDMALLD data = LLDItem.this.model.getModel();
                if (!Model.getInstance().getLibrary().addCDMALinkLevelData(data)) {
                    if (DialogHelper.overrideInLibrary(owner, LLDItem.this.model.toString())) {
                        Model.getInstance().getLibrary().removeCDMALinkLevelData(data);
                        Model.getInstance().getLibrary().addCDMALinkLevelData(data);
                        EventBusFactory.getEventBus().publish(new InfoMessageEvent(String.format("'%s' overridden in CDMA link level data library", LLDItem.this.model.shortText())));
                    }
                } else {
                    EventBusFactory.getEventBus().publish(new InfoMessageEvent(String.format("'%s' added to CDMA link level data library", LLDItem.this.model.shortText())));
                }
            }
        });
        this.workspaceLinkData = new JLabel();
    }

    private void editLinkLevelDataButtonActionPerformed(ActionEvent e) {
        if (this.lldEditor.show(this.model)) {
            this.updateSelectedLinkDataValuePreview();
        }
    }

    private void updateSelectedLinkDataValuePreview() {
        if (this.model == null) {
            this.workspaceLinkData.setText("");
            this.workspaceLinkData.setToolTipText("");
        } else {
            this.workspaceLinkData.setText(this.model.shortText());
            this.workspaceLinkData.setToolTipText(this.model.fullText());
        }
    }

    @Override
    public List<WidgetAndKind> createWidgets() {
        List<WidgetAndKind> widgets = super.createWidgets();
        widgets.add(new WidgetAndKind(this.workspaceLinkData, WidgetKind.LABEL));
        widgets.add(new WidgetAndKind(this.buttons, WidgetKind.VALUE));
        return widgets;
    }

    @Override
    public CDMALLD getValue() {
        return this.model.getModel();
    }

    @Override
    public void setValue(CDMALLD model) {
        this.model = new CDMALinkLevelData(model);
        this.updateSelectedLinkDataValuePreview();
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

