/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.item;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JFrame;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.presentation.DialogMaskFunctionDefine;
import org.seamcat.presentation.genericgui.WidgetAndKind;
import org.seamcat.presentation.genericgui.WidgetKind;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.model.VictimCharacteristics;
import org.seamcat.presentation.valuepreview.ButtonWithValuePreviewTip;
import org.seamcat.presentation.valuepreview.LabelWithValuePreviewTip;
import org.seamcat.presentation.valuepreview.ValuePreviewTextUtil;
import org.seamcat.presentation.valuepreview.ValuePreviewableFunction2Adapter;

public class MaskFunctionItem
extends AbstractItem<MaskFunction, Object> {
    private String functionDialogTitle;
    private MaskFunction function;
    private JFrame parent;
    private String xAxisName;
    private String yAxisName;
    private LabelWithValuePreviewTip valuePreviewLabel;
    private ButtonWithValuePreviewTip functionButton;
    private VictimCharacteristics victimCharacteristics;
    private ActionListener actionListener;

    public MaskFunctionItem(JFrame parent) {
        this.parent = parent;
    }

    public MaskFunctionItem(JFrame parent, String xAxisName, String yAxisName) {
        this.parent = parent;
        this.xAxisName = xAxisName;
        this.yAxisName = yAxisName;
    }

    @Override
    public MaskFunctionItem label(String label) {
        super.label(label);
        return this;
    }

    @Override
    public MaskFunctionItem unit(String unit) {
        super.unit(unit);
        return this;
    }

    public MaskFunctionItem axisNames(String xAxisName, String yAxisName) {
        this.xAxisName = xAxisName;
        this.yAxisName = yAxisName;
        return this;
    }

    public void setVictimCharacteristics(VictimCharacteristics victimCharacteristics) {
        this.victimCharacteristics = victimCharacteristics;
    }

    @Override
    public MaskFunction getValue() {
        return this.function;
    }

    @Override
    public void setValue(MaskFunction value) {
        this.function = value;
        this.updateValuePreview(this.function);
    }

    @Override
    public List<WidgetAndKind> createWidgets() {
        List<WidgetAndKind> widgets = super.createWidgets();
        this.functionButton = new ButtonWithValuePreviewTip("Edit");
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaskFunctionItem.this.showFunctionDialog();
            }
        };
        this.functionButton.addActionListener(this.actionListener);
        widgets.add(new WidgetAndKind(this.functionButton, WidgetKind.VALUE));
        this.valuePreviewLabel = new LabelWithValuePreviewTip();
        widgets.add(new WidgetAndKind(this.valuePreviewLabel, WidgetKind.VALUE_PREVIEW));
        return widgets;
    }

    private void showFunctionDialog() {
        DialogMaskFunctionDefine dialog = new DialogMaskFunctionDefine((Frame)this.parent, true);
        boolean okFromDialog = this.victimCharacteristics != null ? dialog.show(this.function, this.functionDialogTitle, this.victimCharacteristics.getVictimBandwidth(), this.victimCharacteristics.getFrequencyOffset(), this.victimCharacteristics.isShowACLR(), this.victimCharacteristics.getInterfererBandwidth(), this.xAxisName, this.yAxisName) : dialog.show(this.function, this.functionDialogTitle, this.xAxisName, this.yAxisName);
        if (okFromDialog) {
            this.function = dialog.getFunction();
            this.updateValuePreview(this.function);
            this.fireItemChanged();
        }
    }

    private void updateValuePreview(MaskFunction function) {
        this.valuePreviewLabel.setText(ValuePreviewTextUtil.previewLabelText(function.toString()));
        ValuePreviewableFunction2Adapter previewable = new ValuePreviewableFunction2Adapter(function).axisNames(this.xAxisName, this.yAxisName);
        previewable.setVictimCharacteristics(this.victimCharacteristics);
        this.valuePreviewLabel.setPreviewable(previewable);
        this.functionButton.setPreviewable(previewable);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.functionButton.removeActionListener(this.actionListener);
    }
}

