/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.item;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.events.InfoMessageEvent;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.function.EmissionMaskImpl;
import org.seamcat.model.Library;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.Model;
import org.seamcat.model.functions.EmissionMask;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.LibraryItem;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.DialogLibraryMaskFunctionDefine;
import org.seamcat.presentation.ImportSpectrumEmissionMaskDetailPanel;
import org.seamcat.presentation.components.GenericListDetailDialog;
import org.seamcat.presentation.genericgui.WidgetAndKind;
import org.seamcat.presentation.genericgui.WidgetKind;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.model.VictimCharacteristics;
import org.seamcat.presentation.resources.ImageLoader;
import org.seamcat.presentation.valuepreview.ButtonWithValuePreviewTip;
import org.seamcat.presentation.valuepreview.LabelWithValuePreviewTip;
import org.seamcat.presentation.valuepreview.ValuePreviewTextUtil;
import org.seamcat.presentation.valuepreview.ValuePreviewableFunction2Adapter;

public class MaskFunctionLibraryItem<T extends LibraryItem>
extends AbstractItem<T, Object> {
    private Class<T> libraryClass;
    private MaskFunction function;
    private Description description;
    private JFrame parent;
    private LabelWithValuePreviewTip valuePreviewLabel;
    private ButtonWithValuePreviewTip functionButton;
    private JButton importButton;
    private JButton exportButton;
    private JLabel unitLabel = new JLabel();
    ImageIcon importIcon = new ImageIcon(ImageLoader.class.getResource("import_16x16.png"));
    ImageIcon exportIcon = new ImageIcon(ImageLoader.class.getResource("export_16x16.png"));
    private JPanel buttons;

    public MaskFunctionLibraryItem(JFrame parent, Class<T> libraryClass) {
        this.parent = parent;
        this.libraryClass = libraryClass;
    }

    private VictimCharacteristics getVictimCharacteristics() {
        return null;
    }

    @Override
    public MaskFunctionLibraryItem label(String label) {
        super.label(label);
        return this;
    }

    @Override
    public MaskFunctionLibraryItem unit(String unit) {
        super.unit(unit);
        return this;
    }

    @Override
    public T getValue() {
        if (this.libraryClass == EmissionMask.class) {
            return (T)Factory.functionFactory().emissionMask(this.function, this.description);
        }
        return null;
    }

    @Override
    public void setValue(T value) {
        if (this.libraryClass == EmissionMask.class) {
            EmissionMask mask = (EmissionMask)value;
            this.function = mask.getEmissionMask();
            this.description = mask.description();
            this.updateValuePreview(this.function);
        }
    }

    @Override
    public List<WidgetAndKind> createWidgets() {
        List<WidgetAndKind> widgets = super.createWidgets();
        this.functionButton = new ButtonWithValuePreviewTip("Edit");
        this.functionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaskFunctionLibraryItem.this.showFunctionDialog();
            }
        });
        this.importButton = new JButton(this.importIcon);
        this.importButton.setToolTipText("Import");
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MaskFunctionLibraryItem.this.importPressed();
            }
        });
        this.exportButton = new JButton(this.exportIcon);
        this.exportButton.setToolTipText("Export");
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MaskFunctionLibraryItem.this.exportPressed();
            }
        });
        this.buttons = new JPanel(new GridLayout(1, 3));
        this.buttons.add(this.functionButton);
        this.buttons.add(this.importButton);
        this.buttons.add(this.exportButton);
        widgets.add(new WidgetAndKind(this.buttons, WidgetKind.VALUE));
        widgets.add(new WidgetAndKind(this.unitLabel, WidgetKind.UNIT));
        this.valuePreviewLabel = new LabelWithValuePreviewTip();
        widgets.add(new WidgetAndKind(this.valuePreviewLabel, WidgetKind.VALUE_PREVIEW));
        return widgets;
    }

    private void showFunctionDialog() {
        DialogLibraryMaskFunctionDefine dialog = new DialogLibraryMaskFunctionDefine(this.parent, true);
        String title = "Spectrum Emission Mask [Offset (MHz) ; Mask Value (dBc) ; Ref. BW (kHz)]";
        VictimCharacteristics vc = this.getVictimCharacteristics();
        boolean okFromDialog = vc != null ? dialog.show(this.function, this.description, title, vc.getVictimBandwidth(), vc.getFrequencyOffset(), vc.isShowACLR(), vc.getInterfererBandwidth(), "Offset (MHz)", "Mask Value (dBc)") : dialog.show(this.function, this.description, title, "Offset (MHz)", "Mask Value (dBc)");
        if (okFromDialog) {
            dialog.updateModel();
            this.description = dialog.getDescription();
            this.function = dialog.getModel();
            this.updateValuePreview(this.function);
            this.fireItemChanged();
        }
    }

    @Override
    public void setRelevant(boolean relevant) {
        super.setRelevant(relevant);
        for (int i = 0; i < this.buttons.getComponentCount(); ++i) {
            this.buttons.getComponent(i).setEnabled(relevant);
        }
    }

    private void updateValuePreview(MaskFunction function) {
        this.valuePreviewLabel.setText(ValuePreviewTextUtil.previewLabelText(DiscreteFunction.pretty(function)));
        ValuePreviewableFunction2Adapter previewable = new ValuePreviewableFunction2Adapter(function).axisNames("Offset (MHz)", "Mask Value (dBc)");
        previewable.setVictimCharacteristics(this.getVictimCharacteristics());
        this.valuePreviewLabel.setPreviewable(previewable);
        this.functionButton.setPreviewable(previewable);
    }

    private void importPressed() {
        List<EmissionMask> masks;
        GenericListDetailDialog<EmissionMask> dialog;
        if (this.libraryClass == EmissionMask.class && (dialog = new GenericListDetailDialog<EmissionMask>(this.parent, "Import Spectrum Emission Mask", masks = Model.getInstance().getLibrary().getSpectrumEmissionMasks()){

            @Override
            public void selectedElement(EmissionMask fun) {
                this.setDetail(new ImportSpectrumEmissionMaskDetailPanel((EmissionMaskImpl)fun));
            }
        }).display()) {
            this.setValue((T)((LibraryItem)dialog.getSelectedValue()));
        }
    }

    private void exportPressed() {
        if (this.libraryClass == EmissionMask.class) {
            EmissionMask current = (EmissionMask)this.getValue();
            EmissionMaskImpl clone = (EmissionMaskImpl)Factory.functionFactory().emissionMask(current.getEmissionMask(), current.description());
            Library lib = Model.getInstance().getLibrary();
            if (lib.hasLibraryFunction(clone)) {
                if (DialogHelper.overrideInLibrary(this.parent, clone.description().name())) {
                    lib.overrideLibraryFunction(clone);
                    EventBusFactory.getEventBus().publish(new InfoMessageEvent(String.format("'%s' overridden in function library", clone.description().name())));
                    Model.getInstance().persist();
                }
            } else {
                lib.addLibraryFunction(clone);
                EventBusFactory.getEventBus().publish(new InfoMessageEvent(String.format("'%s' added to function library", clone.description().name())));
                Model.getInstance().persist();
            }
        }
    }
}

