/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.item;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.seamcat.model.distributions.AbstractDistribution;
import org.seamcat.presentation.DistributionDialog;
import org.seamcat.presentation.genericgui.WidgetAndKind;
import org.seamcat.presentation.genericgui.WidgetKind;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.genericgui.item.ValueWithUsageFlag;
import org.seamcat.presentation.valuepreview.ButtonWithValuePreviewTip;
import org.seamcat.presentation.valuepreview.LabelWithValuePreviewTip;
import org.seamcat.presentation.valuepreview.ValuePreviewTextUtil;
import org.seamcat.presentation.valuepreview.ValuePreviewableDistributionAdapter;

public class OptionalDistributionItem
extends AbstractItem<ValueWithUsageFlag<AbstractDistribution>, Object> {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private String distributionDialogTitle = "Distribution";
    private AbstractDistribution distribution;
    private JFrame parent;
    private String[] distributions;
    private LabelWithValuePreviewTip valuePreviewLabel;
    private JCheckBox conditionCheckBox;
    private ButtonWithValuePreviewTip distributionButton;

    public OptionalDistributionItem(JFrame parent, String[] distributions) {
        this.parent = parent;
        this.distributions = distributions;
    }

    @Override
    public OptionalDistributionItem label(String label) {
        super.label(label);
        return this;
    }

    @Override
    public OptionalDistributionItem unit(String unit) {
        super.unit(unit);
        return this;
    }

    @Override
    public ValueWithUsageFlag<AbstractDistribution> getValue() {
        return new ValueWithUsageFlag<AbstractDistribution>(this.conditionCheckBox.isSelected(), this.distribution);
    }

    @Override
    public void setValue(ValueWithUsageFlag<AbstractDistribution> value) {
        this.conditionCheckBox.setSelected(value.useValue);
        this.distribution = (AbstractDistribution)value.value;
        this.updateValuePreview(this.distribution);
        this.updateWidgetRelevance();
    }

    @Override
    public List<WidgetAndKind> createWidgets() {
        ArrayList<WidgetAndKind> widgets = new ArrayList<WidgetAndKind>();
        this.conditionCheckBox = new JCheckBox(this.getLabel());
        this.conditionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionalDistributionItem.this.updateWidgetRelevance();
                OptionalDistributionItem.this.fireItemChanged();
            }
        });
        widgets.add(new WidgetAndKind(this.conditionCheckBox, WidgetKind.LABEL));
        this.distributionButton = new ButtonWithValuePreviewTip(STRINGLIST.getString("BTN_CAPTION_DISTRIBUTION"));
        this.distributionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionalDistributionItem.this.showDistributionDialog();
            }
        });
        widgets.add(new WidgetAndKind(this.distributionButton, WidgetKind.VALUE));
        this.valuePreviewLabel = new LabelWithValuePreviewTip();
        widgets.add(new WidgetAndKind(this.valuePreviewLabel, WidgetKind.VALUE_PREVIEW));
        JLabel unitLabel = new JLabel(this.getUnit());
        widgets.add(new WidgetAndKind(unitLabel, WidgetKind.UNIT));
        return widgets;
    }

    @Override
    public void setRelevant(boolean relevant) {
        super.setRelevant(relevant);
        this.updateWidgetRelevance();
    }

    private void showDistributionDialog() {
        DistributionDialog dialog = new DistributionDialog((Frame)this.parent, true, this.distributions);
        if (this.distribution == null) {
            if (dialog.showDistributionDialog(this.distributionDialogTitle)) {
                this.distribution = dialog.getDistribution();
                this.updateValuePreview(this.distribution);
                this.fireItemChanged();
            }
        } else if (dialog.showDistributionDialog(this.distribution, this.distributionDialogTitle)) {
            this.distribution = dialog.getDistribution();
            this.updateValuePreview(this.distribution);
            this.fireItemChanged();
        }
    }

    private void updateValuePreview(AbstractDistribution distribution) {
        this.valuePreviewLabel.setText(ValuePreviewTextUtil.previewLabelText(distribution.toString()));
        this.valuePreviewLabel.setPreviewable(new ValuePreviewableDistributionAdapter(distribution));
        this.distributionButton.setPreviewable(new ValuePreviewableDistributionAdapter(distribution));
    }

    private void updateWidgetRelevance() {
        this.distributionButton.setEnabled(this.isRelevant() && this.conditionCheckBox.isSelected());
    }
}

